/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.model.processors.projects;

import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.general.CIBuildStatusInfo;
import com.hp.octane.integrations.dto.pipelines.PipelinePhase;
import com.hp.octane.integrations.dto.snapshots.CIBuildStatus;
import com.hp.octane.integrations.utils.SdkStringUtils;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.events.OutputEnvironmentParametersHelper;
import com.microfocus.application.automation.tools.octane.model.processors.builders.AbstractBuilderProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.builders.BuildTriggerProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.builders.ParameterizedTriggerProcessor;
import com.microfocus.application.automation.tools.octane.model.processors.parameters.ParameterProcessors;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.tasks.Builder;
import hudson.tasks.Publisher;
import hudson.util.DescribableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import org.apache.logging.log4j.Logger;

public abstract class AbstractProjectProcessor<T extends Job> {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(AbstractProjectProcessor.class);
    private final List<PipelinePhase> internals = new ArrayList<PipelinePhase>();
    private final List<PipelinePhase> postBuilds = new ArrayList<PipelinePhase>();
    private boolean isProcessed = false;
    T job;

    AbstractProjectProcessor(T job) {
        this.job = job;
    }

    public List<Builder> tryGetBuilders() {
        return new ArrayList<Builder>();
    }

    public void scheduleBuild(Cause cause, ParametersAction parametersAction) {
        if (!(this.job instanceof AbstractProject)) {
            throw new IllegalStateException("unsupported job CAN NOT be run");
        }
        AbstractProject project = (AbstractProject)this.job;
        int delay = project.getQuietPeriod();
        project.scheduleBuild(delay, cause, new Action[]{parametersAction});
    }

    public void cancelBuild(Cause cause, ParametersAction parametersAction) {
        String buildId = this.getParameterValueIfExist(parametersAction, "buildId");
        String suiteId = this.getParameterValueIfExist(parametersAction, "suiteId");
        String suiteRunId = this.getParameterValueIfExist(parametersAction, "suiteRunId");
        String releaseExecutionId = this.getParameterValueIfExist(parametersAction, "octane_auto_action_execution_id");
        if (buildId != null) {
            logger.info(String.format("cancelBuild for %s, buildId=%s", this.job.getFullName(), buildId));
            Run aBuild = this.job.getBuild(buildId);
            logger.info(String.format("cancelBuild for %s, buildId=%s - is done", this.job.getFullName(), buildId));
            if (aBuild == null) {
                logger.warn(String.format("Cannot stop : build %s is not found", buildId));
                return;
            }
            this.stopBuild(aBuild);
        } else {
            String paramValueToSearch;
            String paramToSearch;
            FoundInfo foundInfo = new FoundInfo();
            if (SdkStringUtils.isNotEmpty((String)releaseExecutionId)) {
                paramToSearch = "octane_auto_action_execution_id";
                paramValueToSearch = releaseExecutionId;
            } else if (SdkStringUtils.isNotEmpty((String)suiteRunId)) {
                paramToSearch = "suiteRunId";
                paramValueToSearch = suiteRunId;
            } else {
                throw new IllegalArgumentException("Cannot cancel job as no identification parameters was passed");
            }
            logger.info(String.format("cancelBuild for %s, %s=%s", this.job.getFullName(), paramToSearch, paramValueToSearch));
            Queue queue = Jenkins.get().getQueue();
            Queue.Task queueTaskJob = (Queue.Task)this.job;
            queue.getItems(queueTaskJob).forEach(item -> item.getActions(ParametersAction.class).forEach(action -> {
                if (!foundInfo.found && this.checkIfParamExistAndEqual((ParametersAction)action, paramToSearch, paramValueToSearch)) {
                    try {
                        logger.info("canceling item in queue : " + String.valueOf(item));
                        queue.cancel(item);
                        logger.info("Item in queue is cancelled item : " + String.valueOf(item));
                        foundInfo.found = true;
                    }
                    catch (Exception e) {
                        logger.warn("Failed to cancel '" + String.valueOf(item) + "' in queue : " + e.getMessage(), (Throwable)e);
                    }
                }
            }));
            this.job.getBuilds().forEach(build -> {
                if (!foundInfo.found) {
                    Run run = (Run)build;
                    run.getActions(ParametersAction.class).forEach(action -> {
                        if (this.checkIfParamExistAndEqual((ParametersAction)action, paramToSearch, paramValueToSearch)) {
                            this.stopBuild(run);
                            foundInfo.found = true;
                        }
                    });
                }
            });
        }
    }

    public CIBuildStatusInfo getBuildStatus(String paramName, String paramValue) {
        String buildId;
        CIBuildStatusInfo status = ((CIBuildStatusInfo)DTOFactory.getInstance().newDTO(CIBuildStatusInfo.class)).setBuildStatus(CIBuildStatus.UNAVAILABLE).setJobCiId(this.getTranslatedJobName()).setParamName(paramName).setParamValue(paramValue);
        String string = buildId = "buildId".equals(paramName) ? paramValue : null;
        if (buildId != null) {
            try {
                int buildNum = Integer.parseInt(buildId);
                Run aBuild = this.job.getBuildByNumber(buildNum);
                if (aBuild == null) {
                    status.setBuildStatus(CIBuildStatus.UNAVAILABLE);
                }
                status.setBuildCiId(BuildHandlerUtils.getBuildCiId(aBuild));
                status.setAllBuildParams(ParameterProcessors.getInstances(aBuild));
                if (aBuild.isBuilding()) {
                    status.setBuildStatus(CIBuildStatus.RUNNING);
                }
                status.setBuildStatus(CIBuildStatus.FINISHED);
                status.setResult(BuildHandlerUtils.translateRunResult(aBuild));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Failed to parse build id " + buildId);
            }
        } else {
            FoundInfo foundInfo = new FoundInfo();
            if (this.job instanceof Queue.Task) {
                Queue.Task queueTaskJob = (Queue.Task)this.job;
                Queue queue = Jenkins.get().getQueue();
                queue.getItems(queueTaskJob).forEach(item -> item.getActions(ParametersAction.class).forEach(action -> {
                    if (!foundInfo.found && this.checkIfParamExistAndEqual((ParametersAction)action, paramName, paramValue)) {
                        status.setBuildStatus(CIBuildStatus.QUEUED);
                        foundInfo.found = true;
                    }
                }));
            }
            this.job.getBuilds().forEach(build -> {
                if (!foundInfo.found) {
                    Run aBuild = (Run)build;
                    aBuild.getActions(ParametersAction.class).forEach(action -> {
                        if (this.checkIfParamExistAndEqual((ParametersAction)action, paramName, paramValue)) {
                            if (aBuild.isBuilding()) {
                                status.setBuildStatus(CIBuildStatus.RUNNING);
                            } else {
                                status.setBuildStatus(CIBuildStatus.FINISHED);
                                status.setResult(BuildHandlerUtils.translateRunResult(aBuild));
                                status.setEnvironmentOutputtedParameters(OutputEnvironmentParametersHelper.getOutputEnvironmentParams(aBuild));
                            }
                            status.setAllBuildParams(ParameterProcessors.getInstances(aBuild));
                            status.setBuildCiId(BuildHandlerUtils.getBuildCiId(aBuild));
                            foundInfo.found = true;
                        }
                    });
                }
            });
        }
        return status;
    }

    private String getParameterValueIfExist(ParametersAction parametersAction, String paramName) {
        ParameterValue pv = parametersAction.getParameter(paramName);
        if (pv != null) {
            return (String)pv.getValue();
        }
        return null;
    }

    protected void stopBuild(Run run) {
        AbstractBuild aBuild = (AbstractBuild)run;
        try {
            aBuild.doStop();
            logger.info("Build is stopped : " + aBuild.getProject().getDisplayName() + aBuild.getDisplayName());
        }
        catch (Exception e) {
            logger.warn("Failed to stop build '" + aBuild.getDisplayName() + "' :" + e.getMessage(), (Throwable)e);
        }
    }

    private boolean checkIfParamExistAndEqual(ParametersAction parametersAction, String paramName, String expectedValue) {
        ParameterValue pv = parametersAction.getParameter(paramName);
        return SdkStringUtils.isNotEmpty((String)expectedValue) && pv != null && pv.getValue().equals(expectedValue);
    }

    public String getTranslatedJobName() {
        if ("com.cloudbees.hudson.plugins.folder.Folder".equals(this.job.getParent().getClass().getName())) {
            String jobPlainName = this.job.getFullName();
            return BuildHandlerUtils.translateFolderJobName(jobPlainName);
        }
        return this.job.getName();
    }

    public void buildStructure(Set<Job> processedJobs) {
        processedJobs.add((Job)this.job);
        this.buildStructureInternal(processedJobs);
        processedJobs.remove(this.job);
        this.isProcessed = true;
    }

    protected void buildStructureInternal(Set<Job> processedJobs) {
    }

    public List<PipelinePhase> getInternals() {
        if (!this.isProcessed) {
            this.buildStructure(new HashSet<Job>());
        }
        return this.internals;
    }

    public List<PipelinePhase> getPostBuilds() {
        if (!this.isProcessed) {
            this.buildStructure(new HashSet<Job>());
        }
        return this.postBuilds;
    }

    void processBuilders(List<Builder> builders, Job job, Set<Job> processedJobs) {
        this.processBuilders(builders, job, "", processedJobs);
    }

    void processBuilders(List<Builder> builders, Job job, String phasesName, Set<Job> processedJobs) {
        for (Builder builder : builders) {
            AbstractBuilderProcessor.processInternalBuilders(builder, job, phasesName, this.internals, processedJobs);
        }
    }

    void processPublishers(Job job, Set<Job> processedJobs) {
        if (job instanceof AbstractProject) {
            AbstractProject project = (AbstractProject)job;
            processedJobs.add(job);
            DescribableList publishers = project.getPublishersList();
            for (Publisher publisher : publishers) {
                AbstractBuilderProcessor builderProcessor = null;
                if (publisher.getClass().getName().equals("hudson.tasks.BuildTrigger")) {
                    builderProcessor = new BuildTriggerProcessor(publisher, project, processedJobs);
                } else if (publisher.getClass().getName().equals("hudson.plugins.parameterizedtrigger.BuildTrigger")) {
                    builderProcessor = new ParameterizedTriggerProcessor(publisher, project, "", processedJobs);
                }
                if (builderProcessor != null) {
                    this.postBuilds.addAll(builderProcessor.getPhases());
                    continue;
                }
                logger.debug("not yet supported publisher (post build) action: " + publisher.getClass().getName());
            }
            processedJobs.remove(job);
        }
    }

    private static class FoundInfo {
        public boolean found;

        private FoundInfo() {
        }
    }
}

