/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.model;

import com.microfocus.application.automation.tools.sse.common.StringUtils;
import hudson.EnvVars;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Project;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.sonar.SonarGlobalConfiguration;
import hudson.plugins.sonar.SonarInstallation;
import hudson.plugins.sonar.SonarRunnerBuilder;
import hudson.tasks.Builder;
import hudson.util.DescribableList;
import java.io.IOException;
import java.util.Arrays;
import java.util.Optional;
import jenkins.model.GlobalConfiguration;

public class SonarHelper {
    public static final String SONAR_GLOBAL_CONFIG = "hudson.plugins.sonar.SonarGlobalConfiguration";
    private static final String SONAR_ACTION_ID = "hudson.plugins.sonar.SonarRunnerBuilder";
    private static final String SONAR_SERVER_HOST_VARIABLE = "SONAR_HOST_URL";
    private static final String SONAR_SERVER_TOKEN_VARIABLE = "SONAR_AUTH_TOKEN";
    private String serverUrl;
    private String serverToken;

    public SonarHelper(Run<?, ?> run, TaskListener listener) {
        DescribableList postbuilders = null;
        if (run instanceof AbstractBuild) {
            AbstractBuild abstractBuild = (AbstractBuild)run;
            this.setSonarDetailsFromMavenEnvironment(abstractBuild, listener);
            AbstractProject project = abstractBuild.getProject();
            if (StringUtils.isNullOrEmpty(this.getServerUrl()) || StringUtils.isNullOrEmpty(this.getServerToken())) {
                if (project instanceof MavenModuleSet) {
                    postbuilders = ((MavenModuleSet)project).getPostbuilders();
                } else if (project instanceof Project) {
                    postbuilders = ((Project)project).getBuildersList();
                }
                if (postbuilders != null) {
                    this.setDataFromSonarBuilder((DescribableList<Builder, Descriptor<Builder>>)postbuilders, run);
                }
            }
        }
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public String getServerToken() {
        return this.serverToken;
    }

    public static String getSonarInstallationTokenByUrl(GlobalConfiguration sonarConfiguration, String sonarUrl, Run run) {
        SonarGlobalConfiguration sonar;
        Optional<SonarInstallation> installation;
        if (sonarConfiguration instanceof SonarGlobalConfiguration && (installation = Arrays.stream((sonar = (SonarGlobalConfiguration)sonarConfiguration).getInstallations()).filter(sonarInstallation -> sonarInstallation.getServerUrl().equals(sonarUrl)).findFirst()).isPresent()) {
            return SonarHelper.extractAuthenticationToken(installation.get(), run);
        }
        return "";
    }

    private static String extractAuthenticationToken(SonarInstallation sonarInstallation, Run run) {
        return sonarInstallation.getServerAuthenticationToken(run);
    }

    private void setSonarDetailsFromMavenEnvironment(AbstractBuild build, TaskListener listener) {
        try {
            EnvVars environment = build.getEnvironment(listener);
            if (environment != null) {
                this.serverUrl = environment.get(SONAR_SERVER_HOST_VARIABLE, "");
                this.serverToken = environment.get(SONAR_SERVER_TOKEN_VARIABLE, "");
            }
        }
        catch (IOException | InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void setDataFromSonarBuilder(DescribableList<Builder, Descriptor<Builder>> postBuilders, Run run) {
        Builder sonarBuilder = (Builder)postBuilders.getDynamic(SONAR_ACTION_ID);
        if (sonarBuilder != null) {
            SonarRunnerBuilder builder = (SonarRunnerBuilder)sonarBuilder;
            this.serverUrl = this.extractSonarUrl(builder);
            this.serverToken = this.extractSonarToken(builder, run);
        }
    }

    private String extractSonarUrl(SonarRunnerBuilder builder) {
        return builder != null ? builder.getSonarInstallation().getServerUrl() : "";
    }

    private String extractSonarToken(SonarRunnerBuilder builder, Run run) {
        String result = builder != null ? SonarHelper.extractAuthenticationToken(builder.getSonarInstallation(), run) : "";
        return result;
    }

    public static enum DataType {
        VULNERABILITIES,
        COVERAGE;

    }
}

