/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.executor.scmmanager;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.hp.octane.integrations.dto.connectivity.OctaneResponse;
import com.hp.octane.integrations.dto.executor.TestConnectivityInfo;
import com.hp.octane.integrations.dto.scm.SCMRepository;
import com.hp.octane.integrations.dto.scm.SCMType;
import com.microfocus.application.automation.tools.octane.executor.scmmanager.ScmPluginHandler;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.Job;
import hudson.scm.SCM;
import hudson.scm.SubversionSCM;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class SvnPluginHandler
implements ScmPluginHandler {
    @Override
    public void setScmRepositoryInJob(SCMRepository scmRepository, String scmRepositoryCredentialsId, FreeStyleProject proj, boolean executorJob) throws IOException {
        String relativeCheckOut;
        if (executorJob) {
            String url = StringUtils.stripEnd((String)scmRepository.getUrl(), (String)"/").replaceAll("[<>:\"/\\|?*]", "_");
            relativeCheckOut = "a\\..\\..\\..\\_test_sources\\" + url;
        } else {
            relativeCheckOut = "a" + File.separator + "..";
        }
        SubversionSCM svn = new SubversionSCM(scmRepository.getUrl(), scmRepositoryCredentialsId, relativeCheckOut);
        proj.setScm((SCM)svn);
    }

    @Override
    public String getSharedCheckOutDirectory(Job j) {
        SCM scm = ((FreeStyleProject)j).getScm();
        SubversionSCM svnScm = (SubversionSCM)scm;
        for (SubversionSCM.ModuleLocation location : svnScm.getLocations()) {
            if (!StringUtils.isNotEmpty((String)location.getLocalDir())) continue;
            return location.getLocalDir();
        }
        return null;
    }

    @Override
    public void checkRepositoryConnectivity(TestConnectivityInfo testConnectivityInfo, StandardCredentials credentials, OctaneResponse result) {
        String credentialsId = credentials != null ? credentials.getId() : null;
        SubversionSCM svn = new SubversionSCM(testConnectivityInfo.getScmRepository().getUrl(), credentialsId);
        try {
            svn.getDescriptor().checkRepositoryPath((Item)null, svn.getLocations()[0].getSVNURL(), credentials);
            result.setStatus(200);
        }
        catch (Exception e) {
            result.setStatus(500);
            result.setBody("Failed to connect to SVN : " + e.getMessage());
        }
    }

    @Override
    public String getScmRepositoryUrl(SCM scm) {
        return ((SubversionSCM)scm).getLocations()[0].remote;
    }

    @Override
    public String getScmRepositoryCredentialsId(SCM scm) {
        return ((SubversionSCM)scm).getLocations()[0].credentialsId;
    }

    @Override
    public SCMType getScmType() {
        return SCMType.SVN;
    }

    @Override
    public String tryExtractUrlShortName(String url) {
        return url;
    }
}

