/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.executor.scmmanager;

import com.hp.octane.integrations.dto.scm.SCMType;
import com.microfocus.application.automation.tools.octane.executor.scmmanager.GitPluginHandler;
import com.microfocus.application.automation.tools.octane.executor.scmmanager.ScmPluginHandler;
import com.microfocus.application.automation.tools.octane.executor.scmmanager.SvnPluginHandler;
import hudson.PluginWrapper;
import jenkins.model.Jenkins;

public class ScmPluginFactory {
    private static ScmPluginHandler gitPluginHandler = null;
    private static ScmPluginHandler svnPluginHandler = null;

    public static ScmPluginHandler getScmHandler(SCMType scmType) {
        if (SCMType.GIT.equals((Object)scmType)) {
            if (gitPluginHandler == null) {
                gitPluginHandler = new GitPluginHandler();
            }
            return gitPluginHandler;
        }
        if (SCMType.SVN.equals((Object)scmType)) {
            if (svnPluginHandler == null) {
                svnPluginHandler = new SvnPluginHandler();
            }
            return svnPluginHandler;
        }
        throw new IllegalArgumentException("SCM repository " + String.valueOf(scmType) + " isn't supported.");
    }

    public static ScmPluginHandler getScmHandlerByScmPluginName(String pluginName) {
        SCMType scmType = null;
        if ("hudson.plugins.git.GitSCM".equals(pluginName)) {
            scmType = SCMType.GIT;
        } else if ("hudson.scm.SubversionSCM".equals(pluginName)) {
            scmType = SCMType.SVN;
        } else {
            return null;
        }
        return ScmPluginFactory.getScmHandler(scmType);
    }

    public static boolean isPluginInstalled(SCMType scmType) {
        String shortName;
        if (SCMType.GIT.equals((Object)scmType)) {
            shortName = "git";
        } else if (SCMType.SVN.equals((Object)scmType)) {
            shortName = "subversion";
        } else {
            throw new IllegalArgumentException("SCM repository " + String.valueOf(scmType) + " isn't supported.");
        }
        PluginWrapper plugin = Jenkins.getInstanceOrNull().pluginManager.getPlugin(shortName);
        return plugin != null;
    }
}

