/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.executor;

import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneConfiguration;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.executor.impl.TestingToolType;
import com.hp.octane.integrations.services.configurationparameters.factory.ConfigurationParameterFactory;
import com.hp.octane.integrations.uft.UftTestDiscoveryUtils;
import com.hp.octane.integrations.uft.items.AutomatedTest;
import com.hp.octane.integrations.uft.items.OctaneStatus;
import com.hp.octane.integrations.uft.items.ScmResourceFile;
import com.hp.octane.integrations.uft.items.SupportsOctaneStatus;
import com.hp.octane.integrations.uft.items.UftTestDiscoveryResult;
import com.hp.octane.integrations.uft.items.UftTestType;
import com.hp.octane.integrations.utils.SdkStringUtils;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.executor.UFTTestDetectionCallable;
import hudson.FilePath;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;

public class UFTTestDetectionService {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(UFTTestDetectionService.class);
    private static final String INITIAL_DETECTION_FILE = "INITIAL_DETECTION_FILE.txt";
    private static final String DETECTION_RESULT_FILE = "detection_result.json";

    public static UftTestDiscoveryResult startScanning(File rootDir, BuildListener buildListener, String configurationId, String workspaceId, String scmRepositoryId, String testRunnerId, UFTTestDetectionCallable.ScmChangesWrapper scmChangesWrapper, boolean fullScan, TestingToolType testingToolType) {
        UftTestDiscoveryResult result = null;
        try {
            boolean myFullScan;
            boolean bl = myFullScan = fullScan || !UFTTestDetectionService.initialDetectionFileExist(rootDir);
            if (myFullScan) {
                UFTTestDetectionService.printToConsole(buildListener, "Executing full sync");
                result = UftTestDiscoveryUtils.doFullDiscovery((File)rootDir, (TestingToolType)testingToolType);
            } else {
                UFTTestDetectionService.printToConsole(buildListener, "Executing changeSet sync. For full sync - define in job boolean parameter 'Full sync' with value 'true'.");
                result = UFTTestDetectionService.doChangeSetDetection(scmChangesWrapper, rootDir, testingToolType, configurationId);
                UFTTestDetectionService.removeTestDuplicatedForUpdateTests(result);
                UFTTestDetectionService.removeFalsePositiveDataTables(result, result.getDeletedTests(), result.getDeletedScmResourceFiles());
                UFTTestDetectionService.removeFalsePositiveDataTables(result, result.getNewTests(), result.getNewScmResourceFiles());
            }
            UFTTestDetectionService.printResults(buildListener, result);
            if (result.isHasQuotedPaths()) {
                UFTTestDetectionService.printToConsole(buildListener, "This run may not have discovered all updated tests. \nIt seems that the changes in this build included filenames with Unicode characters, which Git did not list correctly.\nTo make sure Git can properly list such file names, configure Git as follows : git config --global core.quotepath false\nTo discover the updated tests that were missed in this run and send them to Software Delivery Management, run this job manually with the \"Full sync\" parameter selected.\n");
            }
            result.setScmRepositoryId(scmRepositoryId);
            result.setConfigurationId(configurationId);
            result.setWorkspaceId(workspaceId);
            result.setFullScan(fullScan);
            if (testRunnerId != null) {
                result.setTestRunnerId(testRunnerId);
            }
            result.sortItems();
            UFTTestDetectionService.createInitialDetectionFile(rootDir);
        }
        catch (Exception e) {
            logger.error("Fail in startScanning : " + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private static void printResults(BuildListener buildListener, UftTestDiscoveryResult result) {
        if (TestingToolType.UFT.equals((Object)result.getTestingToolType())) {
            UFTTestDetectionService.printByStatus(buildListener, result.getAllTests(), "Found %s tests with status %s");
            UFTTestDetectionService.printByStatus(buildListener, result.getAllScmResourceFiles(), "Found %s data tables with status %s");
        } else {
            List actions = result.getAllTests().stream().map(AutomatedTest::getActions).flatMap(Collection::stream).collect(Collectors.toList());
            UFTTestDetectionService.printByStatus(buildListener, actions, "Found %s actions with status %s");
            List parameters = actions.stream().filter(action -> !action.getParameters().isEmpty()).map(action -> action.getParameters()).flatMap(Collection::stream).collect(Collectors.toList());
            UFTTestDetectionService.printByStatus(buildListener, parameters, "Found %s parameters with status %s");
        }
    }

    private static void printByStatus(BuildListener buildListener, List<? extends SupportsOctaneStatus> entities, String messageTemplate) {
        Map<OctaneStatus, Integer> testStatusMap = UFTTestDetectionService.computeStatusMap(entities);
        for (Map.Entry<OctaneStatus, Integer> entry : testStatusMap.entrySet()) {
            UFTTestDetectionService.printToConsole(buildListener, String.format(messageTemplate, entry.getValue(), entry.getKey()));
        }
    }

    private static Map<OctaneStatus, Integer> computeStatusMap(List<? extends SupportsOctaneStatus> entities) {
        HashMap<OctaneStatus, Integer> statusMap = new HashMap<OctaneStatus, Integer>();
        for (SupportsOctaneStatus supportsOctaneStatus : entities) {
            if (!statusMap.containsKey(supportsOctaneStatus.getOctaneStatus())) {
                statusMap.put(supportsOctaneStatus.getOctaneStatus(), 0);
            }
            statusMap.put(supportsOctaneStatus.getOctaneStatus(), (Integer)statusMap.get(supportsOctaneStatus.getOctaneStatus()) + 1);
        }
        return statusMap;
    }

    private static void removeFalsePositiveDataTables(UftTestDiscoveryResult result, List<AutomatedTest> tests, List<ScmResourceFile> scmResourceFiles) {
        if (!scmResourceFiles.isEmpty() && !tests.isEmpty()) {
            ArrayList<ScmResourceFile> falsePositive = new ArrayList<ScmResourceFile>();
            block0: for (ScmResourceFile item : scmResourceFiles) {
                int parentSplitterIndex = item.getRelativePath().lastIndexOf("\\");
                if (parentSplitterIndex == -1) continue;
                String parentName = item.getRelativePath().substring(0, parentSplitterIndex);
                for (AutomatedTest test : tests) {
                    Object testPath = SdkStringUtils.isEmpty((String)test.getPackage()) ? test.getName() : test.getPackage() + "\\" + test.getName();
                    if (!parentName.contains((CharSequence)testPath)) continue;
                    falsePositive.add(item);
                    continue block0;
                }
            }
            result.getAllScmResourceFiles().removeAll(falsePositive);
        }
    }

    private static void removeTestDuplicatedForUpdateTests(UftTestDiscoveryResult result) {
        HashSet<CallSite> keys = new HashSet<CallSite>();
        ArrayList<AutomatedTest> testsToRemove = new ArrayList<AutomatedTest>();
        for (AutomatedTest test : result.getUpdatedTests()) {
            String key = test.getPackage() + "_" + test.getName();
            if (keys.contains(key)) {
                testsToRemove.add(test);
            }
            keys.add((CallSite)((Object)key));
        }
        result.getAllTests().removeAll(testsToRemove);
    }

    public static void printToConsole(BuildListener buildListener, String msg) {
        if (buildListener != null) {
            buildListener.getLogger().println("UFTTestDetectionService : " + msg);
        }
    }

    private static UftTestDiscoveryResult doChangeSetDetection(UFTTestDetectionCallable.ScmChangesWrapper scmChangesWrapper, File workspace, TestingToolType testingToolType, String configurationId) {
        UftTestDiscoveryResult result = new UftTestDiscoveryResult();
        result.setTestingToolType(testingToolType);
        scmChangesWrapper.getAffectedFiles().sort(Comparator.comparing(UFTTestDetectionCallable.ScmChangeAffectedFileWrapper::getPath));
        LinkedList<UFTTestDetectionCallable.ScmChangeAffectedFileWrapper> dataTableAffectFiles = new LinkedList<UFTTestDetectionCallable.ScmChangeAffectedFileWrapper>();
        for (UFTTestDetectionCallable.ScmChangeAffectedFileWrapper affectedFileWrapper : scmChangesWrapper.getAffectedFiles()) {
            if (affectedFileWrapper.getPath().startsWith("\"")) {
                result.setHasQuotedPaths(true);
            }
            String affectedFileFullPath = String.valueOf(workspace) + File.separator + affectedFileWrapper.getPath();
            if (!affectedFileWrapper.isSvnDirType()) {
                if (UftTestDiscoveryUtils.isTestMainFilePath((String)affectedFileWrapper.getPath())) {
                    UFTTestDetectionService.handleUftTestChanges(workspace, testingToolType, result, affectedFileWrapper, affectedFileFullPath);
                    continue;
                }
                if (TestingToolType.UFT.equals((Object)testingToolType) && UftTestDiscoveryUtils.isUftDataTableFile((String)affectedFileWrapper.getPath())) {
                    UFTTestDetectionService.handleUftDataTableChanges(workspace, result, affectedFileWrapper, affectedFileFullPath, dataTableAffectFiles);
                    continue;
                }
                if (!TestingToolType.MBT.equals((Object)testingToolType) || !UftTestDiscoveryUtils.isUftActionFile((String)affectedFileWrapper.getPath())) continue;
                UFTTestDetectionService.handleUftActionChanges(workspace, result, affectedFileWrapper, affectedFileFullPath);
                continue;
            }
            if (!UFTTestDetectionCallable.ScmChangeEditTypeWrapper.DELETE.equals(affectedFileWrapper.getEditType())) continue;
            FilePath filePath = new FilePath(new File(affectedFileWrapper.getPath()));
            String deletedFolder = filePath.getRemote().replace("/", "\\");
            result.getDeletedFolders().add(deletedFolder);
        }
        OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)configurationId);
        if (ConfigurationParameterFactory.isUftTestsDeepRenameCheckEnabled((OctaneConfiguration)octaneClient.getConfigurationService().getConfiguration())) {
            UFTTestDetectionService.createDataTableHashCodeToTestPath(dataTableAffectFiles, result);
        }
        return result;
    }

    private static void createDataTableHashCodeToTestPath(List<UFTTestDetectionCallable.ScmChangeAffectedFileWrapper> dataTableAffectFiles, UftTestDiscoveryResult result) {
        HashMap<String, List> combineDataTableHashCodeToTests = new HashMap<String, List>();
        for (AutomatedTest test : result.getAllTests()) {
            String testPath = test.getPackage() + "\\" + test.getName();
            String finalTestPath = testPath.replace("\\", "/");
            String allDataTableEffected = dataTableAffectFiles.stream().filter(dataTableAffectFile -> dataTableAffectFile.getPath().indexOf(finalTestPath) == 0).map(dataTableAffectFile -> dataTableAffectFile.getPath().substring(finalTestPath.length() + 1) + ":" + dataTableAffectFile.getGitDst()).collect(Collectors.joining("-"));
            combineDataTableHashCodeToTests.computeIfAbsent(UFTTestDetectionService.convertToHashCode(allDataTableEffected).toString(), k -> new LinkedList()).add(testPath);
        }
        result.setCombineDataTableHashCodeToTestPathListMap(combineDataTableHashCodeToTests);
    }

    private static StringBuilder convertToHashCode(String key) {
        StringBuilder sb = new StringBuilder();
        StringBuilder returnString = new StringBuilder();
        returnString.append(key);
        try {
            byte[] keyByteUTF8 = key.getBytes(StandardCharsets.UTF_8);
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(keyByteUTF8, 0, keyByteUTF8.length);
            byte[] mdbytes = md.digest();
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (Exception e) {
            logger.error("failed to calculate hash code: " + e.getMessage());
        }
        if (sb.length() > 0) {
            return sb;
        }
        return returnString;
    }

    private static void handleUftTestChanges(File workspace, TestingToolType testingToolType, UftTestDiscoveryResult result, UFTTestDetectionCallable.ScmChangeAffectedFileWrapper affectedFileWrapper, String affectedFileFullPath) {
        File testFolder = UftTestDiscoveryUtils.getTestFolderForTestMainFile((String)affectedFileFullPath);
        File affectedFile = new File(affectedFileFullPath);
        boolean fileExist = affectedFile.exists();
        UftTestType uftTestType = UftTestDiscoveryUtils.getUftTestType((String)affectedFileWrapper.getPath());
        AutomatedTest test = UftTestDiscoveryUtils.createAutomatedTest((File)workspace, (File)testFolder, (UftTestType)uftTestType, (TestingToolType)testingToolType);
        test.setChangeSetSrc(affectedFileWrapper.getGitSrc());
        test.setChangeSetDst(affectedFileWrapper.getGitDst());
        if (UFTTestDetectionCallable.ScmChangeEditTypeWrapper.ADD.equals(affectedFileWrapper.getEditType())) {
            if (fileExist) {
                result.getAllTests().add(test);
            }
        } else if (UFTTestDetectionCallable.ScmChangeEditTypeWrapper.DELETE.equals(affectedFileWrapper.getEditType())) {
            if (!fileExist) {
                test.setOctaneStatus(OctaneStatus.DELETED);
                test.setExecutable(Boolean.valueOf(false));
                result.getAllTests().add(test);
            }
        } else if (UFTTestDetectionCallable.ScmChangeEditTypeWrapper.EDIT.equals(affectedFileWrapper.getEditType()) && fileExist) {
            test.setOctaneStatus(OctaneStatus.MODIFIED);
            result.getAllTests().add(test);
        }
    }

    private static void handleUftDataTableChanges(File workspace, UftTestDiscoveryResult result, UFTTestDetectionCallable.ScmChangeAffectedFileWrapper affectedFileWrapper, String affectedFileFullPath, List<UFTTestDetectionCallable.ScmChangeAffectedFileWrapper> dataTableAffectFiles) {
        dataTableAffectFiles.add(affectedFileWrapper);
        File affectedFile = new File(affectedFileFullPath);
        ScmResourceFile resourceFile = UftTestDiscoveryUtils.createDataTable((File)workspace, (File)affectedFile);
        resourceFile.setChangeSetSrc(affectedFileWrapper.getGitSrc());
        resourceFile.setChangeSetDst(affectedFileWrapper.getGitDst());
        if (UFTTestDetectionCallable.ScmChangeEditTypeWrapper.ADD.equals(affectedFileWrapper.getEditType())) {
            UftTestType testType = UftTestDiscoveryUtils.isUftTestFolder((File[])affectedFile.getParentFile().listFiles());
            if (testType.isNone() && affectedFile.exists()) {
                result.getAllScmResourceFiles().add(resourceFile);
            }
        } else if (UFTTestDetectionCallable.ScmChangeEditTypeWrapper.DELETE.equals(affectedFileWrapper.getEditType()) && !affectedFile.exists()) {
            resourceFile.setOctaneStatus(OctaneStatus.DELETED);
            result.getAllScmResourceFiles().add(resourceFile);
        }
    }

    private static void handleUftActionChanges(File workspace, UftTestDiscoveryResult result, UFTTestDetectionCallable.ScmChangeAffectedFileWrapper affectedFileWrapper, String affectedFileFullPath) {
    }

    private static boolean initialDetectionFileExist(File rootFile) {
        try {
            File file = new File(rootFile, INITIAL_DETECTION_FILE);
            return file.exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void createInitialDetectionFile(File rootFile) {
        try {
            File file = new File(rootFile, INITIAL_DETECTION_FILE);
            logger.info("Initial detection file path : " + file.getPath());
            file.createNewFile();
        }
        catch (IOException e) {
            logger.error("Failed to createInitialDetectionFile : " + e.getMessage());
        }
    }

    public static void publishDetectionResults(Run run, TaskListener taskListenerLog, UftTestDiscoveryResult detectionResult) {
        File file = UFTTestDetectionService.getDetectionResultFile(run);
        try {
            detectionResult.writeToFile(file);
        }
        catch (Exception e) {
            String msg = "Failed to persist detection results : " + e.getMessage();
            if (taskListenerLog != null) {
                taskListenerLog.error(msg);
            }
            logger.error(msg);
        }
    }

    public static UftTestDiscoveryResult readDetectionResults(Run run) {
        File file = UFTTestDetectionService.getDetectionResultFile(run);
        try {
            return UftTestDiscoveryResult.readFromFile((File)file);
        }
        catch (IOException e) {
            logger.error("Failed to read detection results : " + e.getMessage());
            return null;
        }
    }

    public static File getDetectionResultFile(Run run) {
        return new File(run.getRootDir(), DETECTION_RESULT_FILE);
    }
}

