/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.executor;

import com.hp.octane.integrations.uft.items.UftTestDiscoveryResult;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import jenkins.MasterToSlaveFileCallable;
import org.apache.logging.log4j.Logger;
import org.jenkinsci.remoting.RoleChecker;

public class UFTTestDetectionFinalResultSaverCallable
extends MasterToSlaveFileCallable<String> {
    private UftTestDiscoveryResult results;
    private int buildNumber;
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(UFTTestDetectionFinalResultSaverCallable.class);

    public UFTTestDetectionFinalResultSaverCallable(UftTestDiscoveryResult results, int buildNumber) {
        this.results = results;
        this.buildNumber = buildNumber;
    }

    public String invoke(File file, VirtualChannel virtualChannel) {
        File subWorkspace = new File(file, "_Final_Detection_Results");
        try {
            if (!subWorkspace.exists()) {
                subWorkspace.mkdirs();
            }
            File reportXmlFile = new File(subWorkspace, "final_detection_result_build_" + this.buildNumber + ".json");
            this.results.writeToFile(reportXmlFile);
        }
        catch (IOException e) {
            logger.error("Failed to write final_detection_result file :" + e.getMessage());
        }
        return null;
    }

    public void checkRoles(RoleChecker roleChecker) throws SecurityException {
    }
}

