/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.configuration;

import com.hp.octane.integrations.OctaneClient;
import com.hp.octane.integrations.OctaneSDK;
import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.dto.entities.ResponseEntityList;
import com.hp.octane.integrations.dto.general.CIServerInfo;
import com.hp.octane.integrations.dto.general.ListItem;
import com.hp.octane.integrations.dto.general.Taxonomy;
import com.hp.octane.integrations.dto.pipelines.PipelineContext;
import com.hp.octane.integrations.dto.pipelines.PipelineContextList;
import com.hp.octane.integrations.dto.pipelines.PipelineNode;
import com.hp.octane.integrations.services.entities.EntitiesService;
import com.hp.octane.integrations.services.entities.QueryHelper;
import com.microfocus.application.automation.tools.model.OctaneServerSettingsModel;
import com.microfocus.application.automation.tools.octane.CIJenkinsServicesImpl;
import com.microfocus.application.automation.tools.octane.Messages;
import com.microfocus.application.automation.tools.octane.configuration.ConfigurationService;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import com.microfocus.application.automation.tools.octane.model.ModelFactory;
import com.microfocus.application.automation.tools.octane.model.processors.projects.JobProcessorFactory;
import com.microfocus.application.automation.tools.octane.tests.build.BuildHandlerUtils;
import hudson.model.Job;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.jenkinsci.plugins.workflow.multibranch.WorkflowMultiBranchProject;
import org.kohsuke.stapler.bind.JavaScriptMethod;

public class JobConfigurationProxy {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(JobConfigurationProxy.class);
    private static final DTOFactory dtoFactory = DTOFactory.getInstance();
    private static final String MILESTONE_ID_FIELD = "milestoneId";
    private static final String RELEASE_ID_FIELD = "releaseId";
    private static final String WORKSPACE_ID_FIELD = "workspaceId";
    private static final String NAME_FIELD = "name";
    public static final String INSTANCE_ID_FIELD = "instanceId";
    public static final String ID_FIELD = "id";
    public static final String TEXT_FIELD = "text";
    private static final String IGNORE_TESTS = "ignoreTests";
    private static final String FIELDS = "fields";
    private static final String TAXONOMY_TAGS = "taxonomyTags";
    private static final String FIELD_CREATE_MESSAGE = "Failed to create pipeline";
    private final Job job;
    private final WorkflowMultiBranchProject multibranch;
    private static final String NOT_SPECIFIED = "-- Not specified --";

    JobConfigurationProxy(Job job, WorkflowMultiBranchProject multiBranchProject) {
        this.job = job;
        this.multibranch = multiBranchProject;
    }

    @JavaScriptMethod
    public JSONObject createPipelineOnServer(JSONObject pipelineObject) {
        JSONObject result = new JSONObject();
        if (this.multibranch != null) {
            return this.createMultiBranchOnServer(pipelineObject);
        }
        PipelineNode pipelineNode = ModelFactory.createStructureItem(this.job);
        String instanceId = pipelineObject.getString(INSTANCE_ID_FIELD);
        CIServerInfo ciServerInfo = CIJenkinsServicesImpl.getJenkinsServerInfo();
        ciServerInfo.setInstanceId(instanceId);
        OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)instanceId);
        try {
            PipelineContext pipelineContext = ((PipelineContext)dtoFactory.newDTO(PipelineContext.class)).setContextName(pipelineObject.getString(NAME_FIELD)).setWorkspace(pipelineObject.getLong(WORKSPACE_ID_FIELD)).setReleaseId(Long.valueOf(pipelineObject.getLong(RELEASE_ID_FIELD))).setMilestoneId(Long.valueOf(pipelineObject.getLong(MILESTONE_ID_FIELD))).setStructure((Object)pipelineNode).setServer((Object)ciServerInfo);
            PipelineContext createdPipelineContext = octaneClient.getPipelineContextService().createPipeline(octaneClient.getInstanceId(), pipelineNode.getJobCiId(), pipelineContext);
            octaneClient.getConfigurationService().addToOctaneRootsCache(pipelineNode.getJobCiId());
            Entity workspace = this.getWorkspace(octaneClient, pipelineContext.getWorkspaceId());
            JSONObject pipelineJSON = JobConfigurationProxy.fromPipeline(createdPipelineContext, workspace);
            JobConfigurationProxy.enrichPipelineInstanceId(pipelineJSON, instanceId);
            JobConfigurationProxy.enrichPipelineInternal(pipelineJSON, octaneClient);
            result.put("pipeline", (Object)pipelineJSON);
            JSONArray fieldsMetadata = JobConfigurationProxy.convertToJsonMetadata(JobConfigurationProxy.getPipelineListNodeFieldsMetadata(octaneClient, createdPipelineContext.getWorkspaceId()));
            result.put("fieldsMetadata", (Object)fieldsMetadata);
        }
        catch (ClientException e) {
            logger.warn(FIELD_CREATE_MESSAGE, (Throwable)e);
            return JobConfigurationProxy.error(e.getMessage(), e.getLink());
        }
        catch (Exception e) {
            logger.warn(FIELD_CREATE_MESSAGE, (Throwable)e);
            return JobConfigurationProxy.error(e.getMessage());
        }
        return result;
    }

    private Entity getWorkspace(OctaneClient octaneClient, Long workspaceId) throws ClientException {
        List<Entity> workspaces = JobConfigurationProxy.getWorkspacesById(octaneClient, Collections.singletonList(workspaceId));
        if (workspaces.size() != 1) {
            throw new ClientException("WorkspaceName could not be retrieved for workspaceId: " + workspaceId);
        }
        return workspaces.get(0);
    }

    public JSONObject createMultiBranchOnServer(JSONObject pipelineObject) {
        JSONObject result = new JSONObject();
        try {
            EntitiesService entitiesService;
            List results;
            String ciId = this.multibranch.getFullName();
            String name = pipelineObject.getString(NAME_FIELD);
            Long workspaceId = pipelineObject.getLong(WORKSPACE_ID_FIELD);
            long releaseId = pipelineObject.getLong(RELEASE_ID_FIELD);
            long milestoneId = pipelineObject.getLong(MILESTONE_ID_FIELD);
            String instanceId = pipelineObject.getString(INSTANCE_ID_FIELD);
            OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)instanceId);
            String condition = QueryHelper.condition((String)"instance_id", (String)instanceId);
            ResponseEntityList response = JobConfigurationProxy.queryEntitiesByName(octaneClient, null, Collections.singletonList(condition), workspaceId, "ci_servers", 1);
            if (response != null && response.getTotalCount() == 0 && response.getData() != null) {
                throw new ClientException(String.format("CI Server not exist on Octane please create it on workspace %s, Instance ID %s.", workspaceId, instanceId));
            }
            Entity CIServer2 = (Entity)response.getData().get(0);
            Entity release = releaseId > 0L ? ((Entity)dtoFactory.newDTO(Entity.class)).setType("release").setId(Long.toString(releaseId)) : null;
            Entity milestone = milestoneId > 0L ? ((Entity)dtoFactory.newDTO(Entity.class)).setType("milestone").setId(Long.toString(milestoneId)) : null;
            Entity pipeline = ((Entity)dtoFactory.newDTO(Entity.class)).setField("ci_server", (Object)CIServer2).setField(NAME_FIELD, (Object)name).setField("root_job_name", (Object)ciId);
            if (release != null) {
                pipeline.setField("current_release", (Object)release);
            }
            if (milestone != null) {
                pipeline.setField("current_milestone", (Object)milestone);
            }
            if ((results = (entitiesService = octaneClient.getEntitiesService()).postEntities(workspaceId, "pipelines", Collections.singletonList(pipeline), (Collection)Stream.of(NAME_FIELD, "current_release", "current_milestone").collect(Collectors.toList()))).size() != 1) {
                throw new ClientException(FIELD_CREATE_MESSAGE);
            }
            Entity workspace = this.getWorkspace(octaneClient, workspaceId);
            Entity pipelineCreated = (Entity)results.get(0);
            JSONObject pipelineJSON = new JSONObject();
            pipelineJSON.put(ID_FIELD, (Object)pipelineCreated.getId());
            pipelineJSON.put(NAME_FIELD, (Object)pipelineCreated.getStringValue(NAME_FIELD));
            pipelineJSON.put(RELEASE_ID_FIELD, this.getReferenceFieldId("current_release", pipelineCreated));
            pipelineJSON.put(MILESTONE_ID_FIELD, this.getReferenceFieldId("current_milestone", pipelineCreated));
            pipelineJSON.put("isRoot", (Object)true);
            pipelineJSON.put(WORKSPACE_ID_FIELD, (Object)workspaceId);
            pipelineJSON.put("workspaceName", (Object)workspace.getName());
            pipelineJSON.put(IGNORE_TESTS, (Object)false);
            pipelineJSON.put(FIELDS, (Object)new JSONObject());
            pipelineJSON.put(TAXONOMY_TAGS, (Object)new JSONArray());
            JobConfigurationProxy.enrichPipelineInstanceId(pipelineJSON, instanceId);
            JobConfigurationProxy.enrichPipelineInternal(pipelineJSON, octaneClient);
            result.put("pipeline", (Object)pipelineJSON);
            JSONArray fieldsMetadata = JobConfigurationProxy.convertToJsonMetadata(JobConfigurationProxy.getPipelineListNodeFieldsMetadata(octaneClient, workspaceId));
            result.put("fieldsMetadata", (Object)fieldsMetadata);
        }
        catch (ClientException e) {
            logger.warn(FIELD_CREATE_MESSAGE, (Throwable)e);
            return JobConfigurationProxy.error(e.getMessage(), e.getLink());
        }
        catch (Exception e) {
            logger.warn(FIELD_CREATE_MESSAGE, (Throwable)e);
            return JobConfigurationProxy.error(e.getMessage());
        }
        return result;
    }

    private Object getReferenceFieldId(String fieldName, Entity entity) {
        return entity.getEntityValue(fieldName) != null ? entity.getEntityValue(fieldName).getId() : Integer.valueOf(-1);
    }

    @JavaScriptMethod
    public JSONObject updatePipelineOnSever(JSONObject pipelineObject) {
        JSONObject result = new JSONObject();
        String instanceId = pipelineObject.getString(INSTANCE_ID_FIELD);
        OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)instanceId);
        try {
            long pipelineId = pipelineObject.getLong(ID_FIELD);
            LinkedList<Taxonomy> taxonomies = new LinkedList<Taxonomy>();
            JSONArray taxonomyTags = pipelineObject.getJSONArray(TAXONOMY_TAGS);
            for (JSONObject jsonObject : JobConfigurationProxy.toCollection(taxonomyTags)) {
                taxonomies.add(((Taxonomy)dtoFactory.newDTO(Taxonomy.class)).setId(Long.valueOf(jsonObject.optLong("tagId"))).setName(jsonObject.getString("tagName")).setParent(((Taxonomy)dtoFactory.newDTO(Taxonomy.class)).setId(Long.valueOf(jsonObject.optLong("tagTypeId"))).setName(jsonObject.getString("tagTypeName"))));
            }
            HashMap fields = new HashMap();
            JSONArray fieldTags = pipelineObject.getJSONArray("fieldTags");
            for (JSONObject jsonObject : JobConfigurationProxy.toCollection(fieldTags)) {
                LinkedList<ListItem> assignedValues = new LinkedList<ListItem>();
                for (JSONObject value : JobConfigurationProxy.toCollection(jsonObject.getJSONArray("values"))) {
                    String id = value.containsKey((Object)ID_FIELD) ? value.getString(ID_FIELD) : null;
                    assignedValues.add(((ListItem)dtoFactory.newDTO(ListItem.class)).setId(id).setName(value.getString(NAME_FIELD)));
                }
                fields.put(jsonObject.getString(NAME_FIELD), assignedValues);
            }
            String jobCiId = this.job != null ? JobProcessorFactory.getFlowProcessor(this.job).getTranslatedJobName() : BuildHandlerUtils.translateFolderJobName(this.multibranch.getFullName());
            PipelineContext pipelineContext = ((PipelineContext)dtoFactory.newDTO(PipelineContext.class)).setContextEntityId(pipelineId).setContextName(pipelineObject.getString(NAME_FIELD)).setWorkspace(pipelineObject.getLong(WORKSPACE_ID_FIELD)).setReleaseId(Long.valueOf(pipelineObject.getLong(RELEASE_ID_FIELD))).setMilestoneId(Long.valueOf(pipelineObject.getLong(MILESTONE_ID_FIELD))).setIgnoreTests(Boolean.valueOf(pipelineObject.getBoolean(IGNORE_TESTS))).setTaxonomies(taxonomies).setListFields(fields);
            PipelineContext pipeline = octaneClient.getPipelineContextService().updatePipeline(octaneClient.getInstanceId(), jobCiId, pipelineContext);
            Entity workspace = this.getWorkspace(octaneClient, pipeline.getWorkspaceId());
            JSONObject pipelineJSON = JobConfigurationProxy.fromPipeline(pipeline, workspace);
            JobConfigurationProxy.enrichPipelineInstanceId(pipelineJSON, instanceId);
            JobConfigurationProxy.enrichPipelineInternal(pipelineJSON, octaneClient);
            result.put("pipeline", (Object)pipelineJSON);
            String originalName = pipelineObject.get(NAME_FIELD).toString();
            String updatedName = pipelineJSON.get(NAME_FIELD).toString();
            if (!originalName.equalsIgnoreCase(updatedName)) {
                JSONObject errorObj = new JSONObject();
                errorObj.put("message", (Object)"Failed to update pipeline name. Make sure not to enter the name of an existing pipeline.");
                result.put("error", (Object)errorObj);
            }
        }
        catch (ClientException e) {
            logger.warn("Failed to update pipeline", (Throwable)e);
            return JobConfigurationProxy.error(e.getMessage(), e.getLink());
        }
        catch (Exception e) {
            logger.warn("Failed to update pipeline", (Throwable)e);
            return JobConfigurationProxy.error("Unable to update pipeline");
        }
        return result;
    }

    @JavaScriptMethod
    public JSONObject deleteTests(JSONObject pipelineObject) {
        JSONObject result = new JSONObject();
        String instanceId = pipelineObject.getString(INSTANCE_ID_FIELD);
        OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)instanceId);
        try {
            long pipelineId = pipelineObject.getLong(ID_FIELD);
            long workspaceId = pipelineObject.getLong(WORKSPACE_ID_FIELD);
            octaneClient.getPipelineContextService().deleteTestsFromPipelineNodes(this.job.getName(), pipelineId, workspaceId);
            result.put("Test deletion was successful", (Object)"");
        }
        catch (Exception e) {
            logger.warn("Failed to delete tests", (Throwable)e);
            return JobConfigurationProxy.error("Unable to delete tests");
        }
        return result;
    }

    @JavaScriptMethod
    public JSONObject loadJobConfigurationFromServer(String instanceId) {
        OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)instanceId);
        JSONObject ret = new JSONObject();
        JSONObject workspaces = new JSONObject();
        JSONArray fieldsMetadata = new JSONArray();
        try {
            String jobCiId = this.job != null ? JobProcessorFactory.getFlowProcessor(this.job).getTranslatedJobName() : BuildHandlerUtils.translateFolderJobName(this.multibranch.getFullName());
            PipelineContextList pipelineContextList = octaneClient.getPipelineContextService().getJobConfiguration(octaneClient.getInstanceId(), jobCiId);
            if (!pipelineContextList.getData().isEmpty()) {
                Map workspacesMap = pipelineContextList.buildWorkspace2PipelinesMap();
                HashMap<Long, String> relatedWorkspaces = new HashMap<Long, String>();
                List<Entity> workspaceList = JobConfigurationProxy.getWorkspacesById(octaneClient, workspacesMap.keySet());
                for (Entity workspace : workspaceList) {
                    relatedWorkspaces.put(Long.parseLong(workspace.getId()), workspace.getName());
                }
                TreeMap sortedWorkspacesMap = new TreeMap(Comparator.comparing(Entity::getName));
                Comparator<PipelineContext> pipelineComparator = Comparator.comparing(PipelineContext::getContextEntityName);
                for (Map.Entry workspacePipelines : workspacesMap.entrySet()) {
                    Entity relatedWorkspace = (Entity)dtoFactory.newDTO(Entity.class);
                    relatedWorkspace.setId(((Long)workspacePipelines.getKey()).toString());
                    relatedWorkspace.setName((String)relatedWorkspaces.get(workspacePipelines.getKey()));
                    JSONObject relatedPipelinesJSON = new JSONObject();
                    for (PipelineContext relatedPipeline : (List)workspacePipelines.getValue()) {
                        JSONObject pipelineJSON = JobConfigurationProxy.fromPipeline(relatedPipeline, relatedWorkspace);
                        JobConfigurationProxy.enrichPipelineInstanceId(pipelineJSON, instanceId);
                        relatedPipelinesJSON.put(String.valueOf(relatedPipeline.getContextEntityId()), (Object)pipelineJSON);
                    }
                    JSONObject workspaceJSON = new JSONObject();
                    workspaceJSON.put(ID_FIELD, (Object)relatedWorkspace.getId());
                    workspaceJSON.put(NAME_FIELD, (Object)relatedWorkspace.getName());
                    workspaceJSON.put("pipelines", (Object)relatedPipelinesJSON);
                    workspaces.put(String.valueOf(relatedWorkspace.getId()), (Object)workspaceJSON);
                    LinkedList<PipelineContext> workspacePipelinesList = new LinkedList<PipelineContext>((Collection)workspacePipelines.getValue());
                    workspacePipelinesList.sort(pipelineComparator);
                    sortedWorkspacesMap.put(relatedWorkspace, workspacePipelinesList);
                }
                Entity preSelectedWorkspace = (Entity)sortedWorkspacesMap.keySet().iterator().next();
                PipelineContext preSelectedPipeline = (PipelineContext)((List)sortedWorkspacesMap.get(preSelectedWorkspace)).get(0);
                JSONObject preSelectedPipelineJSON = JobConfigurationProxy.fromPipeline(preSelectedPipeline, preSelectedWorkspace);
                JobConfigurationProxy.enrichPipelineInstanceId(preSelectedPipelineJSON, instanceId);
                JobConfigurationProxy.enrichPipelineInternal(preSelectedPipelineJSON, octaneClient);
                ret.put("currentPipeline", (Object)preSelectedPipelineJSON);
                fieldsMetadata = JobConfigurationProxy.convertToJsonMetadata(JobConfigurationProxy.getPipelineListNodeFieldsMetadata(octaneClient, Long.parseLong(preSelectedWorkspace.getId())));
            }
            ret.put("workspaces", (Object)workspaces);
            ret.put("fieldsMetadata", (Object)fieldsMetadata);
        }
        catch (Exception e) {
            logger.warn("Failed to retrieve job configuration", (Throwable)e);
            return JobConfigurationProxy.error("Unable to retrieve job configuration");
        }
        return ret;
    }

    @JavaScriptMethod
    public JSONObject loadWorkspaceConfiguration(JSONObject pipelineJSON) {
        String instanceId = pipelineJSON.getString(INSTANCE_ID_FIELD);
        OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)instanceId);
        JSONObject ret = new JSONObject();
        try {
            JSONArray fieldsMetadata = JobConfigurationProxy.convertToJsonMetadata(JobConfigurationProxy.getPipelineListNodeFieldsMetadata(octaneClient, pipelineJSON.getLong(WORKSPACE_ID_FIELD)));
            ret.put("fieldsMetadata", (Object)fieldsMetadata);
            JobConfigurationProxy.enrichPipelineInternal(pipelineJSON, octaneClient);
            ret.put("pipeline", (Object)pipelineJSON);
        }
        catch (Exception e) {
            logger.warn("Failed to retrieve metadata for workspace", (Throwable)e);
            return JobConfigurationProxy.error("Unable to retrieve metadata for workspace");
        }
        return ret;
    }

    private static JSONObject fromPipeline(PipelineContext pipeline, Entity relatedWorkspace) {
        JSONObject pipelineJSON = new JSONObject();
        pipelineJSON.put(ID_FIELD, (Object)pipeline.getContextEntityId());
        pipelineJSON.put(NAME_FIELD, (Object)pipeline.getContextEntityName());
        pipelineJSON.put(RELEASE_ID_FIELD, (Object)(pipeline.getReleaseId() != null ? pipeline.getReleaseId() : -1L));
        pipelineJSON.put(MILESTONE_ID_FIELD, (Object)(pipeline.getMilestoneId() != null ? pipeline.getMilestoneId() : -1L));
        pipelineJSON.put("isRoot", (Object)pipeline.isPipelineRoot());
        pipelineJSON.put(WORKSPACE_ID_FIELD, (Object)relatedWorkspace.getId());
        pipelineJSON.put("workspaceName", (Object)relatedWorkspace.getName());
        pipelineJSON.put(IGNORE_TESTS, (Object)pipeline.getIgnoreTests());
        JobConfigurationProxy.addTaxonomyTags(pipelineJSON, pipeline);
        JobConfigurationProxy.addFields(pipelineJSON, pipeline);
        return pipelineJSON;
    }

    @JavaScriptMethod
    public JSONObject enrichPipeline(JSONObject pipelineJSON) {
        String instanceId = pipelineJSON.getString(INSTANCE_ID_FIELD);
        OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)instanceId);
        JSONObject ret = new JSONObject();
        try {
            JobConfigurationProxy.enrichPipelineInternal(pipelineJSON, octaneClient);
            ret.put("pipeline", (Object)pipelineJSON);
        }
        catch (Exception e) {
            logger.warn("Failed to retrieve metadata for pipeline", (Throwable)e);
            return JobConfigurationProxy.error("Unable to retrieve metadata for pipeline");
        }
        return ret;
    }

    private static void enrichPipelineInternal(JSONObject pipelineJSON, OctaneClient octaneClient) {
        JobConfigurationProxy.enrichRelease(pipelineJSON, octaneClient);
        JobConfigurationProxy.enrichMilestone(pipelineJSON, octaneClient);
        JobConfigurationProxy.enrichTaxonomies(pipelineJSON, octaneClient);
        JobConfigurationProxy.enrichFields(pipelineJSON, octaneClient);
    }

    private static void enrichPipelineInstanceId(JSONObject pipelineJSON, String instanceId) {
        pipelineJSON.put(INSTANCE_ID_FIELD, (Object)instanceId);
        pipelineJSON.put("instanceCaption", (Object)ConfigurationService.getSettings(instanceId).getCaption());
    }

    private static void enrichRelease(JSONObject pipeline, OctaneClient octaneClient) {
        long workspaceId = pipeline.getLong(WORKSPACE_ID_FIELD);
        if (pipeline.containsKey((Object)RELEASE_ID_FIELD) && pipeline.getLong(RELEASE_ID_FIELD) != -1L) {
            long releaseId = pipeline.getLong(RELEASE_ID_FIELD);
            String releaseName = JobConfigurationProxy.getReleasesById(octaneClient, Collections.singletonList(releaseId), workspaceId).get(0).getName();
            pipeline.put("releaseName", (Object)releaseName);
        }
    }

    private static void enrichMilestone(JSONObject pipeline, OctaneClient octaneClient) {
        long workspaceId = pipeline.getLong(WORKSPACE_ID_FIELD);
        if (pipeline.containsKey((Object)MILESTONE_ID_FIELD) && pipeline.getLong(MILESTONE_ID_FIELD) != -1L) {
            long milestoneId = pipeline.getLong(MILESTONE_ID_FIELD);
            String milestoneName = JobConfigurationProxy.getMilestonesById(octaneClient, Arrays.asList(milestoneId), workspaceId).get(0).getName();
            pipeline.put("milestoneName", (Object)milestoneName);
        }
    }

    private static void enrichTaxonomies(JSONObject pipeline, OctaneClient octaneClient) {
        JSONArray ret = new JSONArray();
        if (pipeline.has(TAXONOMY_TAGS)) {
            JSONArray taxonomyTags = pipeline.getJSONArray(TAXONOMY_TAGS);
            LinkedList<Long> taxonomyIdsList = new LinkedList<Long>();
            for (int i = 0; i < taxonomyTags.size(); ++i) {
                JSONObject taxonomy = taxonomyTags.getJSONObject(i);
                if (!taxonomy.has("tagId")) continue;
                taxonomyIdsList.add(taxonomy.getLong("tagId"));
            }
            List<Taxonomy> taxonomies = JobConfigurationProxy.convertTaxonomies(JobConfigurationProxy.getTaxonomiesById(octaneClient, taxonomyIdsList, pipeline.getLong(WORKSPACE_ID_FIELD)));
            for (Taxonomy tax : taxonomies) {
                ret.add((Object)JobConfigurationProxy.tag(tax));
            }
        }
        pipeline.put(TAXONOMY_TAGS, (Object)ret);
    }

    private static void enrichFields(JSONObject pipeline, OctaneClient client) {
        JSONObject ret = new JSONObject();
        if (pipeline.has(FIELDS)) {
            long workspaceId = pipeline.getLong(WORKSPACE_ID_FIELD);
            JSONObject pipelineFields = pipeline.getJSONObject(FIELDS);
            Iterator keys = pipelineFields.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!(pipelineFields.get(key) instanceof JSONArray)) continue;
                LinkedList<String> fieldTagsIdsList = new LinkedList<String>();
                for (JSONObject singleField : JobConfigurationProxy.toCollection(pipelineFields.getJSONArray(key))) {
                    fieldTagsIdsList.add(singleField.getString(ID_FIELD));
                }
                if (fieldTagsIdsList.size() <= 0) continue;
                List<Entity> enrichedFields = JobConfigurationProxy.getListItemsById(client, fieldTagsIdsList, workspaceId);
                JSONArray values = new JSONArray();
                JobConfigurationProxy.fillArray(values, enrichedFields, NAME_FIELD, null);
                ret.put(key, (Object)values);
            }
        }
        pipeline.put(FIELDS, (Object)ret);
    }

    @JavaScriptMethod
    public JSONObject searchListItems(String logicalListName, String term, String instanceId, long workspaceId, boolean multiValue, boolean extensible) {
        int defaultSize = 10;
        JSONObject ret = new JSONObject();
        OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)instanceId);
        try {
            String quotedTerm;
            ResponseEntityList listItemPagedList = JobConfigurationProxy.queryListItems(octaneClient, logicalListName, term, workspaceId, defaultSize);
            List listItems = listItemPagedList.getData();
            boolean moreResults = listItemPagedList.getTotalCount() > listItems.size();
            JSONArray retArray = new JSONArray();
            if (moreResults) {
                retArray.add((Object)JobConfigurationProxy.createMoreResultsJson());
            }
            if (!multiValue && Pattern.matches(".*" + (quotedTerm = Pattern.quote(term.toLowerCase())) + ".*", NOT_SPECIFIED.toLowerCase())) {
                JSONObject notSpecifiedItemJson = new JSONObject();
                notSpecifiedItemJson.put(ID_FIELD, (Object)-1);
                notSpecifiedItemJson.put(TEXT_FIELD, (Object)NOT_SPECIFIED);
                retArray.add((Object)notSpecifiedItemJson);
            }
            JobConfigurationProxy.fillArray(retArray, listItems, TEXT_FIELD, this::isNotManualTestingToolType);
            if (!(!extensible || multiValue || listItems.size() == 1 && ((Entity)listItems.get(0)).getName().toLowerCase().equals(term.toLowerCase()))) {
                retArray.add((Object)JobConfigurationProxy.createNewValueJson("0"));
            }
            ret.put("results", (Object)retArray);
        }
        catch (Exception e) {
            logger.warn("Failed to retrieve list items", (Throwable)e);
            return JobConfigurationProxy.error("Unable to retrieve job configuration");
        }
        return ret;
    }

    private boolean isNotManualTestingToolType(Entity item) {
        return !item.getStringValue("logical_name").equalsIgnoreCase("list_node.testing_tool_type.manual");
    }

    @JavaScriptMethod
    public JSONObject searchReleases(String term, String instanceId, long workspaceId) {
        int defaultSize = 5;
        JSONObject ret = new JSONObject();
        OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)instanceId);
        try {
            String quotedTerm;
            ResponseEntityList releasePagedList = JobConfigurationProxy.queryReleasesByName(octaneClient, term, workspaceId, defaultSize);
            List releases = releasePagedList.getData();
            boolean moreResults = releasePagedList.getTotalCount() > releases.size();
            JSONArray retArray = new JSONArray();
            if (moreResults) {
                retArray.add((Object)JobConfigurationProxy.createMoreResultsJson());
            }
            if (Pattern.matches(".*" + (quotedTerm = Pattern.quote(term.toLowerCase())) + ".*", NOT_SPECIFIED.toLowerCase())) {
                JSONObject notSpecifiedItemJson = new JSONObject();
                notSpecifiedItemJson.put(ID_FIELD, (Object)-1);
                notSpecifiedItemJson.put(TEXT_FIELD, (Object)NOT_SPECIFIED);
                retArray.add((Object)notSpecifiedItemJson);
            }
            JobConfigurationProxy.fillArray(retArray, releases, TEXT_FIELD, null);
            ret.put("results", (Object)retArray);
        }
        catch (Exception e) {
            logger.warn("Failed to retrieve releases", (Throwable)e);
            return JobConfigurationProxy.error("Unable to retrieve releases");
        }
        return ret;
    }

    @JavaScriptMethod
    public JSONObject searchMilestones(String term, String instanceId, long workspaceId, long releaseId) {
        int defaultSize = 5;
        JSONObject ret = new JSONObject();
        OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)instanceId);
        try {
            String quotedTerm;
            ResponseEntityList milestonePagedList = JobConfigurationProxy.queryMilestonesByNameAndRelease(octaneClient, term, workspaceId, releaseId, defaultSize);
            List milestones = milestonePagedList.getData();
            boolean moreResults = milestonePagedList.getTotalCount() > milestones.size();
            JSONArray retArray = new JSONArray();
            if (moreResults) {
                retArray.add((Object)JobConfigurationProxy.createMoreResultsJson());
            }
            if (Pattern.matches(".*" + (quotedTerm = Pattern.quote(term.toLowerCase())) + ".*", NOT_SPECIFIED.toLowerCase())) {
                JSONObject notSpecifiedItemJson = new JSONObject();
                notSpecifiedItemJson.put(ID_FIELD, (Object)-1);
                notSpecifiedItemJson.put(TEXT_FIELD, (Object)NOT_SPECIFIED);
                retArray.add((Object)notSpecifiedItemJson);
            }
            JobConfigurationProxy.fillArray(retArray, milestones, TEXT_FIELD, null);
            ret.put("results", (Object)retArray);
        }
        catch (Exception e) {
            logger.warn("Failed to retrieve milestones", (Throwable)e);
            return JobConfigurationProxy.error("Unable to retrieve milestones");
        }
        return ret;
    }

    @JavaScriptMethod
    public JSONObject searchWorkspaces(String term, String instanceId) {
        int defaultSize = 5;
        JSONObject ret = new JSONObject();
        OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)instanceId);
        try {
            ResponseEntityList workspacePagedList = JobConfigurationProxy.queryWorkspacesByName(octaneClient, term, defaultSize);
            List workspaces = workspacePagedList.getData();
            boolean moreResults = workspacePagedList.getTotalCount() > workspaces.size();
            JSONArray retArray = new JSONArray();
            if (moreResults) {
                retArray.add((Object)JobConfigurationProxy.createMoreResultsJson());
            }
            JobConfigurationProxy.fillArray(retArray, workspaces, TEXT_FIELD, null);
            ret.put("results", (Object)retArray);
        }
        catch (Exception e) {
            logger.warn("Failed to retrieve workspaces", (Throwable)e);
            return JobConfigurationProxy.error("Unable to retrieve workspaces");
        }
        return ret;
    }

    private static void fillArray(JSONArray array, List<Entity> entities, String valueFieldName, Predicate<? super Entity> predicate) {
        for (Entity entity : entities) {
            if (predicate != null && !predicate.test((Entity)entity)) continue;
            JSONObject relJson = new JSONObject();
            relJson.put(ID_FIELD, (Object)entity.getId());
            relJson.put(valueFieldName, (Object)entity.getName());
            array.add((Object)relJson);
        }
    }

    @JavaScriptMethod
    public JSONObject searchSharedSpaces(String term) {
        JSONObject ret = new JSONObject();
        JSONArray retArray = new JSONArray();
        for (OctaneServerSettingsModel model : ConfigurationService.getAllSettings()) {
            if (StringUtils.isNotEmpty((String)term) && !model.getCaption().toLowerCase().contains(term.toLowerCase())) continue;
            JSONObject relJson = new JSONObject();
            relJson.put(ID_FIELD, (Object)model.getIdentity());
            relJson.put(TEXT_FIELD, (Object)model.getCaption());
            retArray.add((Object)relJson);
        }
        ret.put("results", (Object)retArray);
        return ret;
    }

    @JavaScriptMethod
    public JSONObject searchTaxonomies(String term, String instanceId, long workspaceId, JSONArray pipelineTaxonomies) {
        int defaultSize = 20;
        JSONObject ret = new JSONObject();
        OctaneClient octaneClient = OctaneSDK.getClientByInstanceId((String)instanceId);
        try {
            LinkedList<Long> pipelineTaxonomiesList = new LinkedList<Long>();
            for (int i = 0; i < pipelineTaxonomies.size(); ++i) {
                JSONObject pipelineTaxonomy = pipelineTaxonomies.getJSONObject(i);
                if (!pipelineTaxonomy.containsKey((Object)"tagId") || !pipelineTaxonomy.containsKey((Object)"tagTypeId")) continue;
                pipelineTaxonomiesList.add(pipelineTaxonomy.getLong("tagId"));
            }
            ResponseEntityList foundTaxonomies = JobConfigurationProxy.queryTaxonomiesByName(octaneClient, term, workspaceId, defaultSize);
            List foundTaxonomiesList = foundTaxonomies.getData();
            boolean moreResults = foundTaxonomies.getTotalCount() > foundTaxonomiesList.size();
            HashMap<String, LinkedHashSet<Entity>> taxonomyMap = new HashMap<String, LinkedHashSet<Entity>>();
            HashMap<String, String> taxonomyCategories = new HashMap<String, String>();
            for (Entity taxonomy : foundTaxonomiesList) {
                Entity root = (Entity)taxonomy.getField("category");
                if (root == null) continue;
                if (taxonomyMap.containsKey(root.getId())) {
                    ((Set)taxonomyMap.get(root.getId())).add(taxonomy);
                    continue;
                }
                taxonomyMap.put(root.getId(), new LinkedHashSet<Entity>(Collections.singletonList(taxonomy)));
                taxonomyCategories.put(root.getId(), root.getName());
            }
            JSONArray select2InputArray = new JSONArray();
            JSONObject allTags = new JSONObject();
            JSONObject tagTypesByName = new JSONObject();
            JSONObject tagTypes = new JSONObject();
            if (moreResults) {
                select2InputArray.add((Object)JobConfigurationProxy.createMoreResultsJson());
            }
            for (Map.Entry taxonomyType : taxonomyMap.entrySet()) {
                String tagTypeId = (String)taxonomyType.getKey();
                String tagTypeName = (String)taxonomyCategories.get(tagTypeId);
                JSONArray childrenArray = new JSONArray();
                JSONObject optgroup = new JSONObject();
                optgroup.put(TEXT_FIELD, (Object)tagTypeName);
                JSONObject tagTypeJson = new JSONObject();
                tagTypeJson.put("tagTypeId", (Object)tagTypeId);
                tagTypeJson.put("tagTypeName", (Object)tagTypeName);
                JSONArray tagTypeByNameValues = new JSONArray();
                for (Entity tax : (Set)taxonomyType.getValue()) {
                    JSONObject taxonomyJson = new JSONObject();
                    taxonomyJson.put(ID_FIELD, (Object)tax.getId());
                    taxonomyJson.put(TEXT_FIELD, (Object)tax.getName());
                    taxonomyJson.put("value", (Object)tax.getId());
                    if (pipelineTaxonomiesList.contains(tax.getId())) {
                        taxonomyJson.put("disabled", (Object)"disabled");
                    }
                    childrenArray.add((Object)taxonomyJson);
                    Entity root = (Entity)tax.getField("category");
                    JSONObject tagObject = new JSONObject();
                    tagObject.put("tagId", (Object)tax.getId());
                    tagObject.put("tagName", (Object)tax.getName());
                    tagObject.put("tagTypeId", (Object)root.getId());
                    tagObject.put("tagTypeName", (Object)root.getName());
                    allTags.put(String.valueOf(tax.getId()), (Object)tagObject);
                    JSONObject tagTypeByNameValue = new JSONObject();
                    tagTypeByNameValue.put("tagId", (Object)tax.getId());
                    tagTypeByNameValue.put("tagName", (Object)tax.getName());
                    tagTypeByNameValues.add((Object)tagTypeByNameValue);
                }
                JSONObject newValueJson = JobConfigurationProxy.createNewValueJson(Long.toString(JobConfigurationProxy.tagTypeValue(Long.parseLong(tagTypeId))));
                childrenArray.add((Object)newValueJson);
                optgroup.put("children", (Object)childrenArray);
                select2InputArray.add((Object)optgroup);
                tagTypeJson.put("values", (Object)tagTypeByNameValues);
                tagTypesByName.put(tagTypeName, (Object)tagTypeJson);
                tagTypes.put(tagTypeId, (Object)tagTypeJson);
            }
            JSONObject optgroup = new JSONObject();
            optgroup.put(TEXT_FIELD, (Object)"New type...");
            JSONObject newValueJson = JobConfigurationProxy.createNewValueJson("newTagType");
            JSONArray childrenArray = new JSONArray();
            childrenArray.add((Object)newValueJson);
            optgroup.put("children", (Object)childrenArray);
            select2InputArray.add((Object)optgroup);
            ret.put("select2Input", (Object)select2InputArray);
            ret.put("allTags", (Object)allTags);
            ret.put("tagTypesByName", (Object)tagTypesByName);
            ret.put("tagTypes", (Object)tagTypes);
            ret.put("more", (Object)moreResults);
        }
        catch (Exception e) {
            logger.warn("Failed to retrieve environments", (Throwable)e);
            return JobConfigurationProxy.error("Unable to retrieve environments");
        }
        return ret;
    }

    private static JSONObject createMoreResultsJson() {
        JSONObject moreResultsJson = new JSONObject();
        moreResultsJson.put(ID_FIELD, (Object)"moreResultsFound");
        moreResultsJson.put(TEXT_FIELD, (Object)Messages.TooManyResults());
        moreResultsJson.put("warning", (Object)"true");
        moreResultsJson.put("disabled", (Object)"disabled");
        return moreResultsJson;
    }

    private static JSONObject createNewValueJson(String id) {
        JSONObject newValueJson = new JSONObject();
        newValueJson.put(ID_FIELD, (Object)id);
        newValueJson.put(TEXT_FIELD, (Object)"New value...");
        newValueJson.put("newValue", (Object)"true");
        return newValueJson;
    }

    private static long tagTypeValue(long n) {
        return -(n + 1L);
    }

    private static void addTaxonomyTags(JSONObject result, PipelineContext pipeline) {
        JSONArray pipelineTaxonomies = new JSONArray();
        for (Taxonomy taxonomy : pipeline.getTaxonomies()) {
            pipelineTaxonomies.add((Object)JobConfigurationProxy.tag(taxonomy));
        }
        result.put(TAXONOMY_TAGS, (Object)pipelineTaxonomies);
    }

    private static void addFields(JSONObject result, PipelineContext pipeline) {
        JSONObject listFields = new JSONObject();
        for (Map.Entry fieldEntry : pipeline.getListFields().entrySet()) {
            JSONArray assignedValuesArray = JobConfigurationProxy.listFieldValues((List)fieldEntry.getValue());
            listFields.put((String)fieldEntry.getKey(), (Object)assignedValuesArray);
        }
        result.put(FIELDS, (Object)listFields);
    }

    private static JSONArray listFieldValues(List<ListItem> listItems) {
        JSONArray ret = new JSONArray();
        for (ListItem item : listItems) {
            JSONObject value = new JSONObject();
            value.put(ID_FIELD, (Object)item.getId());
            if (item.getName() != null) {
                value.put(NAME_FIELD, (Object)item.getName());
            }
            ret.add((Object)value);
        }
        return ret;
    }

    private static Collection<JSONObject> toCollection(JSONArray array) {
        return array.subList(0, array.size());
    }

    private static JSONObject tag(Long tagId, String value) {
        JSONObject tag = new JSONObject();
        tag.put("tagId", (Object)String.valueOf(tagId));
        tag.put("tagName", (Object)value);
        return tag;
    }

    private static JSONObject tag(Taxonomy taxonomy) {
        JSONObject tag = JobConfigurationProxy.tag(taxonomy.getId(), taxonomy.getName());
        if (taxonomy.getParent() != null) {
            tag.put("tagTypeId", (Object)String.valueOf(taxonomy.getParent().getId()));
            tag.put("tagTypeName", (Object)taxonomy.getParent().getName());
        }
        return tag;
    }

    private static JSONObject error(String message) {
        return JobConfigurationProxy.error(message, null);
    }

    private static JSONObject error(String message, ExceptionLink exceptionLink) {
        JSONObject result = new JSONObject();
        JSONArray errors = new JSONArray();
        JSONObject error = new JSONObject();
        error.put("message", (Object)message);
        if (exceptionLink != null) {
            error.put("url", (Object)exceptionLink.getUrl());
            error.put("label", (Object)exceptionLink.getLabel());
        }
        errors.add((Object)error);
        result.put("errors", (Object)errors);
        return result;
    }

    private static ResponseEntityList queryWorkspacesByName(OctaneClient octaneClient, String name, int limit) {
        return JobConfigurationProxy.queryEntitiesByName(octaneClient, name, null, null, "workspaces", limit);
    }

    private static ResponseEntityList queryReleasesByName(OctaneClient octaneClient, String name, long workspaceId, int limit) {
        return JobConfigurationProxy.queryEntitiesByName(octaneClient, name, null, workspaceId, "releases", limit);
    }

    private static ResponseEntityList queryMilestonesByNameAndRelease(OctaneClient octaneClient, String name, long workspaceId, long releaseId, int limit) {
        LinkedList<String> conditions = new LinkedList<String>();
        conditions.add(QueryHelper.conditionRef((String)"release", (String)ID_FIELD, (String)Long.toString(releaseId)));
        return JobConfigurationProxy.queryEntitiesByName(octaneClient, name, conditions, workspaceId, "milestones", limit);
    }

    private static ResponseEntityList queryTaxonomiesByName(OctaneClient octaneClient, String name, long workspaceId, int limit) {
        EntitiesService entityService = octaneClient.getEntitiesService();
        LinkedList<Object> conditions = new LinkedList<Object>();
        conditions.add("!category={null}");
        if (!StringUtils.isEmpty((String)name)) {
            conditions.add(QueryHelper.condition((String)NAME_FIELD, (String)("*" + name + "*")));
            conditions.add("(" + QueryHelper.condition((String)NAME_FIELD, (String)("*" + name + "*")) + "||" + QueryHelper.conditionRef((String)"category", (String)NAME_FIELD, (String)("*" + name + "*")) + ")");
        }
        String url = entityService.buildEntityUrl(Long.valueOf(workspaceId), "taxonomy_nodes", conditions, Arrays.asList(NAME_FIELD, "category"), Integer.valueOf(0), Integer.valueOf(limit), NAME_FIELD);
        ResponseEntityList result = entityService.getPagedEntities(url);
        return result;
    }

    private static ResponseEntityList queryEntitiesByName(OctaneClient octaneClient, String name, Collection<String> conditions, Long workspaceId, String collectionName, int limit) {
        EntitiesService entityService = octaneClient.getEntitiesService();
        if (conditions == null) {
            conditions = new LinkedList<String>();
        }
        if (!StringUtils.isEmpty((String)name)) {
            conditions.add(QueryHelper.condition((String)NAME_FIELD, (String)("*" + name + "*")));
        }
        String url = entityService.buildEntityUrl(workspaceId, collectionName, conditions, Collections.singletonList(NAME_FIELD), Integer.valueOf(0), Integer.valueOf(limit), NAME_FIELD);
        ResponseEntityList result = entityService.getPagedEntities(url);
        return result;
    }

    private static ResponseEntityList queryListItems(OctaneClient octaneClient, String logicalListName, String name, long workspaceId, int limit) {
        ResponseEntityList result;
        int myLimit = limit;
        EntitiesService entityService = octaneClient.getEntitiesService();
        LinkedList<String> conditions = new LinkedList<String>();
        if (!StringUtils.isEmpty((String)name)) {
            myLimit = 100;
        }
        if (!StringUtils.isEmpty((String)logicalListName)) {
            conditions.add(QueryHelper.conditionRef((String)"list_root", (String)"logical_name", (String)logicalListName));
        }
        String url = entityService.buildEntityUrl(Long.valueOf(workspaceId), "list_nodes", conditions, null, Integer.valueOf(0), Integer.valueOf(myLimit), null);
        ResponseEntityList myResult = result = entityService.getPagedEntities(url);
        if (!StringUtils.isEmpty((String)name)) {
            List data = result.getData().stream().filter(l -> l.getName().toLowerCase().contains(name.toLowerCase())).limit(limit).collect(Collectors.toList());
            myResult = (ResponseEntityList)((ResponseEntityList)dtoFactory.newDTO(ResponseEntityList.class)).setData(data);
        }
        return myResult;
    }

    private static List<Entity> getWorkspacesById(OctaneClient client, Collection<?> itemIds) {
        return JobConfigurationProxy.getEntitiesById(client, null, "workspaces", itemIds);
    }

    private static List<Entity> getListItemsById(OctaneClient client, Collection<?> itemIds, long workspaceId) {
        return JobConfigurationProxy.getEntitiesById(client, workspaceId, "list_nodes", itemIds);
    }

    private static List<Entity> getReleasesById(OctaneClient client, Collection<?> itemIds, long workspaceId) {
        return JobConfigurationProxy.getEntitiesById(client, workspaceId, "releases", itemIds);
    }

    private static List<Entity> getMilestonesById(OctaneClient client, Collection<?> itemIds, long workspaceId) {
        return JobConfigurationProxy.getEntitiesById(client, workspaceId, "milestones", itemIds);
    }

    private static List<Entity> getTaxonomiesById(OctaneClient client, Collection<?> itemIds, long workspaceId) {
        return JobConfigurationProxy.getEntitiesById(client, workspaceId, "taxonomy_nodes", itemIds);
    }

    private static List<Taxonomy> convertTaxonomies(List<Entity> entities) {
        ArrayList<Taxonomy> taxonomies = new ArrayList<Taxonomy>();
        for (Entity entity : entities) {
            Taxonomy taxonomy = (Taxonomy)dtoFactory.newDTO(Taxonomy.class);
            taxonomy.setId(Long.valueOf(Long.parseLong(entity.getId()))).setName(entity.getName());
            if (entity.containsField("category")) {
                Taxonomy parent = (Taxonomy)dtoFactory.newDTO(Taxonomy.class);
                parent.setId(Long.valueOf(Long.parseLong(entity.getId()))).setName(entity.getName());
                taxonomy.setParent(parent);
            }
            taxonomies.add(taxonomy);
        }
        return taxonomies;
    }

    private static List<Entity> getEntitiesById(OctaneClient octaneClient, Long workspaceId, String collectionName, Collection<?> itemIds) {
        return octaneClient.getEntitiesService().getEntitiesByIds(workspaceId, collectionName, itemIds);
    }

    private static List<Entity> getPipelineListNodeFieldsMetadata(OctaneClient octaneClient, long workspaceId) {
        LinkedList<String> conditions = new LinkedList<String>();
        conditions.add(QueryHelper.condition((String)"entity_name", (String)"pipeline_node"));
        conditions.add(QueryHelper.conditionIn((String)NAME_FIELD, Arrays.asList("test_tool_type", "test_level", "test_type", "test_framework"), (boolean)false));
        EntitiesService entityService = octaneClient.getEntitiesService();
        String url = entityService.buildEntityUrl(Long.valueOf(workspaceId), "metadata/fields", conditions, null, Integer.valueOf(0), null, null);
        ResponseEntityList list = entityService.getPagedEntities(url);
        return list.getData();
    }

    private static JSONArray convertToJsonMetadata(List<Entity> listNodeFieldMetadataList) {
        JSONArray fieldMetadataArray = new JSONArray();
        for (Entity entity : listNodeFieldMetadataList) {
            Map fieldTypeData = (Map)entity.getField("field_type_data");
            List targets = (List)fieldTypeData.get("targets");
            Map listNodeTarget = (Map)targets.get(0);
            List fieldFeatures = (List)entity.getField("field_features");
            Map pipelineTaggingFeature = null;
            for (Map feature : fieldFeatures) {
                if (!feature.get(NAME_FIELD).equals("pipeline_tagging")) continue;
                pipelineTaggingFeature = feature;
            }
            JSONObject fieldMetadataJSON = new JSONObject();
            fieldMetadataJSON.put(NAME_FIELD, (Object)entity.getName());
            fieldMetadataJSON.put("listName", (Object)entity.getStringValue("label"));
            fieldMetadataJSON.put("logicalListName", listNodeTarget.get("logical_name"));
            fieldMetadataJSON.put("extensible", pipelineTaggingFeature.get("extensibility"));
            fieldMetadataJSON.put("multiValue", fieldTypeData.get("multiple"));
            fieldMetadataJSON.put("order", pipelineTaggingFeature.get("order"));
            fieldMetadataArray.add((Object)fieldMetadataJSON);
        }
        return fieldMetadataArray;
    }

    private static class ClientException
    extends Exception {
        private ExceptionLink link;

        ClientException(String message) {
            this(message, (ExceptionLink)null);
        }

        ClientException(String message, ExceptionLink link) {
            super(message);
            this.link = link;
        }

        public ExceptionLink getLink() {
            return this.link;
        }
    }

    private static class ExceptionLink {
        private String url;
        private String label;

        ExceptionLink(String url, String label) {
            this.url = url;
            this.label = label;
        }

        public String getUrl() {
            return this.url;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

