/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.configuration;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.microfocus.application.automation.tools.octane.configuration.ReflectionUtils;
import com.microfocus.application.automation.tools.octane.configuration.SDKBasedLoggerProvider;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import hudson.tasks.Publisher;
import hudson.util.Secret;
import java.io.IOException;
import java.util.Map;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.logging.log4j.Logger;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;

public class FodConfigUtil {
    private static final Logger logger = SDKBasedLoggerProvider.getLogger(FodConfigUtil.class);
    public static final String FOD_DESCRIPTOR = "org.jenkinsci.plugins.fodupload.FodGlobalDescriptor";
    public static final String FOD_STATIC_ASSESSMENT_STEP = "org.jenkinsci.plugins.fodupload.StaticAssessmentBuildStep";

    public static ServerConnectConfig getFODServerConfig() {
        Descriptor fodDescriptor = FodConfigUtil.getFODDescriptor();
        ServerConnectConfig serverConnectConfig = null;
        if (fodDescriptor != null) {
            serverConnectConfig = new ServerConnectConfig();
            serverConnectConfig.apiUrl = (String)ReflectionUtils.getFieldValue(fodDescriptor, "apiUrl");
            serverConnectConfig.baseUrl = (String)ReflectionUtils.getFieldValue(fodDescriptor, "baseUrl");
            serverConnectConfig.clientId = (String)ReflectionUtils.getFieldValue(fodDescriptor, "clientId");
            serverConnectConfig.clientSecret = FodConfigUtil.retrieveSecretDecryptedValue((String)ReflectionUtils.getFieldValue(fodDescriptor, "clientSecret"));
        }
        return serverConnectConfig;
    }

    private static Descriptor getFODDescriptor() {
        return Jenkins.getInstanceOrNull().getDescriptorByName(FOD_DESCRIPTOR);
    }

    public static Long getFODReleaseFromBuild(AbstractBuild build) {
        return build != null ? FodConfigUtil.getRelease(build.getProject()) : null;
    }

    public static Long getFODReleaseFromRun(WorkflowRun run) {
        logger.debug("implement get release for " + String.valueOf(run));
        return null;
    }

    private static Long getRelease(AbstractProject project) {
        Long release = FodConfigUtil.getReleaseId(project);
        if (release != null) {
            return release;
        }
        logger.debug("Falling back to retrieving release from BSI Token");
        release = FodConfigUtil.getReleaseVersionBefore12(project);
        if (release != null) {
            logger.debug("A Version before 12 is detected.");
            return release;
        }
        release = FodConfigUtil.getReleaseVersion12(project);
        if (release != null) {
            logger.debug("A Version 12 or higher is detected.");
        }
        logger.debug("No release was set to this job");
        return release;
    }

    private static Long getReleaseId(AbstractProject project) {
        for (Object publisher : project.getPublishersList()) {
            if (!(publisher instanceof Publisher) || !FOD_STATIC_ASSESSMENT_STEP.equals(publisher.getClass().getName())) continue;
            Object sharedBuildStep = ReflectionUtils.getFieldValue(publisher, "sharedBuildStep");
            if (sharedBuildStep != null) {
                logger.debug(sharedBuildStep.toString());
                return FodConfigUtil.getReleaseIdByReflection(sharedBuildStep);
            }
            return FodConfigUtil.getReleaseIdByReflection(publisher);
        }
        return null;
    }

    private static Long getReleaseIdByReflection(Object fodPublisher) {
        Object modelObj = ReflectionUtils.getFieldValue(fodPublisher, "model");
        if (modelObj == null) {
            return null;
        }
        String releaseId = (String)ReflectionUtils.getFieldValue(modelObj, "releaseId");
        if (releaseId != null) {
            return Long.valueOf(releaseId);
        }
        logger.debug("Unable to find releaseId directly");
        return null;
    }

    private static Long getReleaseVersion12(AbstractProject project) {
        for (Object publisher : project.getPublishersList()) {
            if (!(publisher instanceof Publisher) || !FOD_STATIC_ASSESSMENT_STEP.equals(publisher.getClass().getName())) continue;
            return FodConfigUtil.getReleaseByReflectionV12(publisher);
        }
        return null;
    }

    private static Long getReleaseVersionBefore12(AbstractProject project) {
        for (Object publisher : project.getPublishersList()) {
            if (!(publisher instanceof Publisher) || !FOD_STATIC_ASSESSMENT_STEP.equals(publisher.getClass().getName())) continue;
            return FodConfigUtil.getReleaseByReflection(publisher);
        }
        return null;
    }

    private static Long getReleaseByReflectionV12(Object fodPublisher) {
        Object sharedBuildStep = ReflectionUtils.getFieldValue(fodPublisher, "sharedBuildStep");
        if (sharedBuildStep == null) {
            return null;
        }
        return FodConfigUtil.getReleaseByReflection(sharedBuildStep);
    }

    private static Long getReleaseByReflection(Object fodPublisher) {
        Object modelObj = ReflectionUtils.getFieldValue(fodPublisher, "model");
        if (modelObj == null) {
            return null;
        }
        String bsiToken = (String)ReflectionUtils.getFieldValue(modelObj, "bsiTokenOriginal");
        return FodConfigUtil.parseBSITokenAndGetReleaseId(bsiToken);
    }

    private static Long parseBSITokenAndGetReleaseId(String bsiToken) {
        try {
            return FodConfigUtil.handleURLFormat(bsiToken);
        }
        catch (Exception e) {
            return FodConfigUtil.handleBase64Format(bsiToken);
        }
    }

    private static Long handleBase64Format(String bsiToken) {
        String bsi64 = StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)bsiToken));
        try {
            Map bsiJsonAsMap = (Map)new ObjectMapper().readValue(bsi64, TypeFactory.defaultInstance().constructType(Map.class));
            return Long.valueOf(bsiJsonAsMap.get("releaseId").toString());
        }
        catch (IOException e) {
            logger.error("failed to read the BSI token base64:" + e.getMessage());
            return null;
        }
    }

    private static Long handleURLFormat(String bsiToken) {
        if (bsiToken == null) {
            return null;
        }
        int pvIndex = bsiToken.indexOf("pv");
        String releaseString = bsiToken.substring(bsiToken.indexOf(61, pvIndex) + 1, bsiToken.indexOf(38, pvIndex));
        return Long.valueOf(releaseString);
    }

    public static String decrypt(String stringToDecrypt) {
        Secret decryptedSecret = Secret.decrypt((String)stringToDecrypt);
        return decryptedSecret != null ? decryptedSecret.getPlainText() : stringToDecrypt;
    }

    public static String decrypt(Secret stringToDecrypt) {
        return stringToDecrypt.getPlainText();
    }

    public static String encrypt(String stringToEncrypt) {
        String result = stringToEncrypt;
        if (Secret.decrypt((String)stringToEncrypt) == null) {
            result = Secret.fromString((String)stringToEncrypt).getEncryptedValue();
        }
        return result;
    }

    public static boolean isEncrypted(String stringToEncrypt) {
        return Secret.decrypt((String)stringToEncrypt) != null;
    }

    public static boolean isCredential(String id) {
        StringCredentials s = (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{null, null}), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)id)}));
        return s != null;
    }

    public static String retrieveSecretDecryptedValue(String id) {
        StringCredentials s = (StringCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StringCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, (DomainRequirement[])new DomainRequirement[]{null, null}), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)id)}));
        return s != null ? FodConfigUtil.decrypt(s.getSecret()) : id;
    }

    public static class ServerConnectConfig {
        public String baseUrl;
        public String apiUrl;
        public String clientId;
        public String clientSecret;
    }
}

