/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane.actions.coverage;

import hudson.FilePath;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import jenkins.MasterToSlaveFileCallable;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;

public class CoverageService {
    private static final String COVERAGE_REPORT_FILE_NAME_PREFIX = "coverage_report";
    private static TaskListener listener;

    public static String getCoverageReportFileName(int index, String fileSuffix) {
        return COVERAGE_REPORT_FILE_NAME_PREFIX + index + "-" + fileSuffix;
    }

    public static String[] getCoverageFiles(FilePath workspace, String glob) throws IOException, InterruptedException {
        CoverageService.log(String.format("Looking for files that match the pattern %s in root directory %s", glob, workspace.getName()));
        return (String[])workspace.act((FilePath.FileCallable)new ResultFilesCallable(glob));
    }

    public static void copyCoverageFile(File resultFile, File targetReportFile, FilePath workspace) throws IOException, InterruptedException {
        CoverageService.log(String.format("Copying %s to %s", resultFile.getPath(), targetReportFile));
        byte[] content = (byte[])workspace.act((FilePath.FileCallable)new FileContentCallable(resultFile));
        if (CoverageService.validateContent(content)) {
            CoverageService.log("Got coverage file content");
            try (FileOutputStream os = new FileOutputStream(targetReportFile);){
                os.write(content);
            }
            CoverageService.log(String.format("coverage file copied successfully to %s", targetReportFile.getPath()));
        } else {
            CoverageService.log("coverage file content corrupted, failed to copy the file to target destination");
        }
    }

    private static boolean validateContent(byte[] content) {
        return content.length > 0;
    }

    public static void log(String message) {
        if (listener != null) {
            listener.getLogger().println(message);
        }
    }

    public static void setListener(TaskListener l) {
        listener = l;
    }

    private static final class ResultFilesCallable
    extends MasterToSlaveFileCallable<String[]> {
        private final String glob;

        private ResultFilesCallable(String glob) {
            this.glob = glob;
        }

        public String[] invoke(File rootDir, VirtualChannel channel) throws IOException {
            FileSet fs = Util.createFileSet((File)rootDir, (String)this.glob);
            DirectoryScanner ds = fs.getDirectoryScanner();
            return ds.getIncludedFiles();
        }
    }

    private static final class FileContentCallable
    extends MasterToSlaveFileCallable<byte[]> {
        private final File file;

        private FileContentCallable(File file) {
            this.file = file;
        }

        public byte[] invoke(File rootDir, VirtualChannel channel) throws IOException {
            return Files.readAllBytes(this.file.toPath());
        }
    }

    public static class Lcov {
        public static final String LCOV_TYPE = "LCOV";
        public static final String LCOV_FILE_EXTENSION = ".info";
        public static final String LCOV_DEFAULT_FILE_NAME = "lcov.info";
        public static final String LCOV_DEFAULT_PATH = "**/coverage/lcov.info";
    }

    public static class Jacoco {
        public static final String JACOCO_TYPE = "JACOCOXML";
        public static final String JACOCO_FILE_EXTENSION = ".xml";
        public static final String JACOCO_DEFAULT_FILE_NAME = "jacoco.xml";
        public static final String JACOCO_DEFAULT_PATH = "**/target/site/*/jacoco.xml";
    }
}

