/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.octane;

import java.io.Serializable;

public interface ResultQueue {
    public QueueItem peekFirst();

    public boolean failed();

    public void remove();

    public void add(QueueItem var1);

    public void add(String var1, int var2);

    public void add(String var1, String var2, int var3);

    public void add(String var1, int var2, String var3);

    public void add(String var1, String var2, int var3, String var4);

    public void clear();

    public void close();

    public static class QueueItem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String instanceId;
        public String type;
        String projectName;
        int buildNumber;
        String workspace;
        int failCount;
        long sendAfter;

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public void setType(String type) {
            this.type = type;
        }

        public QueueItem(String projectName, int buildNumber) {
            this(projectName, buildNumber, 0);
        }

        public QueueItem(String projectName, String type, int buildNumber) {
            this(projectName, buildNumber, 0);
            this.type = type;
        }

        public QueueItem(String projectName, int buildNumber, String workspace) {
            this(projectName, buildNumber, 0);
            this.workspace = workspace;
        }

        QueueItem(String projectName, int buildNumber, int failCount) {
            this.projectName = projectName;
            this.buildNumber = buildNumber;
            this.failCount = failCount;
        }

        QueueItem(String projectName, int buildNumber, int failCount, String workspace) {
            this.projectName = projectName;
            this.buildNumber = buildNumber;
            this.failCount = failCount;
            this.workspace = workspace;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public String getType() {
            return this.type;
        }

        public int incrementFailCount() {
            return this.failCount++;
        }

        public int getFailCount() {
            return this.failCount;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public int getBuildNumber() {
            return this.buildNumber;
        }

        public String getWorkspace() {
            return this.workspace;
        }

        public long getSendAfter() {
            return this.sendAfter;
        }

        public void setSendAfter(long sendAfter) {
            this.sendAfter = sendAfter;
        }
    }
}

