/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.model;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SvServiceSelectionModel
extends AbstractDescribableImpl<SvServiceSelectionModel>
implements Serializable {
    protected final SelectionType selectionType;
    protected final String service;
    protected final String projectPath;
    protected final Secret projectPassword;

    @DataBoundConstructor
    public SvServiceSelectionModel(SelectionType selectionType, String service, String projectPath, String projectPassword) {
        Validate.notNull((Object)((Object)selectionType), (String)"SelectionType must be specified");
        this.selectionType = selectionType;
        this.service = StringUtils.trim((String)service);
        this.projectPath = StringUtils.trim((String)projectPath);
        this.projectPassword = Secret.fromString((String)projectPassword);
    }

    public SelectionType getSelectionType() {
        return this.selectionType;
    }

    public String getService() {
        return StringUtils.isNotBlank((String)this.service) ? this.service : null;
    }

    public String getProjectPath() {
        return StringUtils.isNotBlank((String)this.projectPath) ? this.projectPath : null;
    }

    public String getProjectPassword() {
        return this.projectPassword != null ? this.projectPassword.getPlainText() : null;
    }

    public boolean isSelected(String selectionType) {
        return SelectionType.valueOf(selectionType) == this.selectionType;
    }

    public static enum SelectionType {
        SERVICE,
        PROJECT,
        ALL_DEPLOYED,
        DEPLOY;

    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SvServiceSelectionModel> {
        @Nonnull
        public String getDisplayName() {
            return "Service Selection";
        }

        public FormValidation doCheckService(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Service name or id must be set");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProjectPath(@QueryParameter String value) {
            if (StringUtils.isBlank((String)value)) {
                return FormValidation.error((String)"Project path cannot be empty");
            }
            return FormValidation.ok();
        }
    }
}

