/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.model;

import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import hudson.util.Secret;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class SvServerSettingsModel
implements Serializable {
    private final String name;
    private final String url;
    private final boolean trustEveryone;
    private final String username;
    private final Secret password;

    @DataBoundConstructor
    public SvServerSettingsModel(String name, String url, boolean trustEveryone, String username, Secret password) {
        this.name = StringUtils.trim((String)name);
        this.url = StringUtils.trim((String)url);
        this.trustEveryone = trustEveryone;
        this.username = username;
        this.password = password;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public URL getUrlObject() throws MalformedURLException {
        return new URL(this.url);
    }

    public boolean isTrustEveryone() {
        return this.trustEveryone;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password.getPlainText();
    }

    public Credentials getCredentials() {
        if (StringUtils.isBlank((String)this.username) || this.password == null) {
            return null;
        }
        return new Credentials(this.username, this.password.getPlainText());
    }
}

