/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.model;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class SvDataModelSelection
extends AbstractDescribableImpl<SvDataModelSelection>
implements Serializable {
    protected final SelectionType selectionType;
    protected final String dataModel;

    @DataBoundConstructor
    public SvDataModelSelection(SelectionType selectionType, String dataModel) {
        this.selectionType = selectionType;
        this.dataModel = StringUtils.trim((String)dataModel);
    }

    public static void validateField(FormValidation result) {
        if (!result.equals(FormValidation.ok())) {
            throw new IllegalArgumentException(StringEscapeUtils.unescapeXml((String)result.getMessage()));
        }
    }

    public SelectionType getSelectionType() {
        return this.selectionType;
    }

    public String getDataModel() {
        return StringUtils.isNotBlank((String)this.dataModel) ? this.dataModel : null;
    }

    public boolean isSelected(String type) {
        return SelectionType.valueOf(type) == this.selectionType;
    }

    public boolean isNoneSelected() {
        return this.selectionType == SelectionType.NONE;
    }

    public boolean isDefaultSelected() {
        return this.selectionType == SelectionType.DEFAULT;
    }

    public String toString() {
        switch (this.selectionType.ordinal()) {
            case 0: {
                return this.dataModel;
            }
            case 1: {
                return "<none>";
            }
        }
        return "<default>";
    }

    public String getSelectedModelName() {
        switch (this.selectionType.ordinal()) {
            case 0: {
                SvDataModelSelection.validateField(DescriptorImpl.doCheckDataModelImpl(this.dataModel));
                return this.dataModel;
            }
        }
        return null;
    }

    public static enum SelectionType implements Serializable
    {
        BY_NAME,
        NONE,
        DEFAULT;

    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SvDataModelSelection> {
        @Nonnull
        public String getDisplayName() {
            return "Data model Selection";
        }

        public FormValidation doCheckDataModel(@QueryParameter String dataModel) {
            return DescriptorImpl.doCheckDataModelImpl(dataModel);
        }

        private static FormValidation doCheckDataModelImpl(@QueryParameter String dataModel) {
            if (StringUtils.isBlank((String)dataModel)) {
                return FormValidation.error((String)"Data model cannot be empty if 'Specific' model is selected");
            }
            return FormValidation.ok();
        }
    }
}

