/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.model;

import com.microfocus.application.automation.tools.octane.exceptions.AggregatedMessagesException;
import hudson.util.Secret;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.apache.http.annotation.Obsolete;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class OctaneServerSettingsModel
implements Serializable {
    private String internalId = UUID.randomUUID().toString();
    private String identity;
    private Long identityFrom;
    private String uiLocation;
    private String username;
    private Secret password;
    private String impersonatedUser;
    private boolean suspend;
    private String sscBaseToken;
    private boolean fortifyParamsConverted;
    private String location;
    private String sharedSpace;
    private String workspace2ImpersonatedUserConf;
    private Map<Long, String> workspace2ImpersonatedUserMap;
    private String parameters;

    public OctaneServerSettingsModel() {
    }

    @DataBoundConstructor
    public OctaneServerSettingsModel(String uiLocation, String username, Secret password, String impersonatedUser) {
        this.uiLocation = StringUtils.trim((String)uiLocation);
        this.username = StringUtils.trim((String)username);
        this.password = password;
        this.impersonatedUser = StringUtils.trim((String)impersonatedUser);
    }

    public String getInternalId() {
        return this.internalId;
    }

    public boolean isSuspend() {
        return this.suspend;
    }

    @DataBoundSetter
    public void setSuspend(boolean suspend) {
        this.suspend = suspend;
    }

    @Obsolete
    public String getSscBaseToken() {
        return this.sscBaseToken;
    }

    @DataBoundSetter
    @Obsolete
    public void setSscBaseToken(String sscBaseToken) {
        this.sscBaseToken = sscBaseToken;
    }

    public String getUiLocation() {
        return this.uiLocation;
    }

    public String getUsername() {
        return this.username;
    }

    public Secret getPassword() {
        return this.password;
    }

    public String getImpersonatedUser() {
        return this.impersonatedUser;
    }

    public String getIdentity() {
        return this.identity;
    }

    @DataBoundSetter
    public void setIdentity(String identity) {
        this.identity = StringUtils.trim((String)identity);
        this.setIdentityFrom(new Date().getTime());
    }

    public Long getIdentityFrom() {
        return this.identityFrom;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = StringUtils.trim((String)location);
    }

    public String getSharedSpace() {
        return this.sharedSpace;
    }

    public void setSharedSpace(String sharedSpace) {
        this.sharedSpace = StringUtils.trim((String)sharedSpace);
    }

    public void setIdentityFrom(Long identityFrom) {
        this.identityFrom = identityFrom;
    }

    public boolean isValid() {
        return this.identity != null && !this.identity.isEmpty() && this.location != null && !this.location.isEmpty() && this.internalId != null && !this.internalId.isEmpty() && this.sharedSpace != null && !this.sharedSpace.isEmpty();
    }

    public void setInternalId(String internalId) {
        this.internalId = internalId;
    }

    public String getCaption() {
        return this.getLocation() + "?p=" + this.getSharedSpace();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OctaneServerSettingsModel that = (OctaneServerSettingsModel)o;
        return this.suspend == that.suspend && Objects.equals(this.identity, that.identity) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.impersonatedUser, that.impersonatedUser) && Objects.equals(this.location, that.location) && Objects.equals(this.workspace2ImpersonatedUserConf, that.workspace2ImpersonatedUserConf) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.sharedSpace, that.sharedSpace);
    }

    public int hashCode() {
        return Objects.hash(this.identity, this.username, this.password, this.impersonatedUser, this.suspend, this.location, this.sharedSpace, this.internalId, this.getWorkspace2ImpersonatedUserConf());
    }

    public String getWorkspace2ImpersonatedUserConf() {
        return this.workspace2ImpersonatedUserConf;
    }

    @DataBoundSetter
    public void setWorkspace2ImpersonatedUserConf(String workspace2ImpersonatedUserConf) {
        this.workspace2ImpersonatedUserConf = workspace2ImpersonatedUserConf;
        this.workspace2ImpersonatedUserMap = OctaneServerSettingsModel.parseWorkspace2ImpersonatedUserConf(workspace2ImpersonatedUserConf, true);
    }

    public Map<Long, String> getWorkspace2ImpersonatedUserMap() {
        if (this.workspace2ImpersonatedUserMap == null) {
            this.workspace2ImpersonatedUserMap = Collections.emptyMap();
        }
        return this.workspace2ImpersonatedUserMap;
    }

    public static Map<Long, String> parseWorkspace2ImpersonatedUserConf(String workspace2ImpersonatedUserConf, boolean ignoreErrors) {
        HashMap<Long, String> workspace2ImpersonatedUserMap = new HashMap<Long, String>();
        ArrayList<String> errorsFound = new ArrayList<String>();
        if (workspace2ImpersonatedUserConf != null) {
            String[] parts;
            for (String workspaceConfiguration : parts = workspace2ImpersonatedUserConf.split("\\n")) {
                try {
                    OctaneServerSettingsModel.parseWorkspaceConfiguration(workspace2ImpersonatedUserMap, workspaceConfiguration);
                }
                catch (IllegalArgumentException e) {
                    errorsFound.add(e.getMessage());
                }
            }
        }
        if (!ignoreErrors && !errorsFound.isEmpty()) {
            throw new AggregatedMessagesException(errorsFound);
        }
        return workspace2ImpersonatedUserMap;
    }

    private static void parseWorkspaceConfiguration(Map<Long, String> workspace2ImpersonatedUserMap, String workspaceConfiguration) {
        String workspaceConfigurationTrimmed = workspaceConfiguration.trim();
        if (workspaceConfigurationTrimmed.isEmpty() || workspaceConfigurationTrimmed.startsWith("#")) {
            return;
        }
        int splitterIndex = workspaceConfiguration.indexOf(58);
        if (splitterIndex == -1) {
            throw new IllegalArgumentException("Workspace configuration is not valid, valid format is 'Workspace ID:jenkins user': " + workspaceConfigurationTrimmed);
        }
        Long workspaceId = OctaneServerSettingsModel.getLongOrNull(workspaceConfiguration.substring(0, splitterIndex));
        if (workspaceId == null) {
            throw new IllegalArgumentException("Workspace configuration is not valid, workspace ID must be numeric: " + workspaceConfigurationTrimmed);
        }
        String user = workspaceConfiguration.substring(splitterIndex + 1).trim();
        if (user.isEmpty()) {
            throw new IllegalArgumentException("Workspace configuration is not valid, user value is empty: " + workspaceConfigurationTrimmed);
        }
        if (workspace2ImpersonatedUserMap.containsKey(workspaceId)) {
            throw new IllegalArgumentException("Duplicated workspace configuration: " + workspaceConfigurationTrimmed);
        }
        workspace2ImpersonatedUserMap.put(workspaceId, user);
    }

    private static Long getLongOrNull(String str) {
        try {
            return Long.parseLong(str.trim());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String getParameters() {
        return this.parameters;
    }

    public Map<String, String> getParametersAsMap() {
        return OctaneServerSettingsModel.parseParameters(this.parameters);
    }

    public static Map<String, String> parseParameters(String rawParameters) {
        String[] parts;
        HashMap<String, String> map = new HashMap<String, String>();
        if (rawParameters == null) {
            return map;
        }
        for (String part : parts = rawParameters.split("\\n")) {
            String key;
            String trimmedPart = part.trim();
            if (trimmedPart.isEmpty() || trimmedPart.startsWith("#")) continue;
            String value = null;
            int separation = trimmedPart.indexOf(58);
            if (separation > 0) {
                key = trimmedPart.substring(0, separation).trim();
                value = trimmedPart.substring(separation + 1).trim();
            } else {
                key = trimmedPart;
            }
            map.put(key, value);
        }
        return map;
    }

    @DataBoundSetter
    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    public boolean isFortifyParamsConverted() {
        return this.fortifyParamsConverted;
    }

    public void setFortifyParamsConverted(boolean fortifyParamsConverted) {
        this.fortifyParamsConverted = fortifyParamsConverted;
    }
}

