/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.model;

import com.microfocus.application.automation.tools.mc.AuthType;
import hudson.util.Secret;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class AuthModel
implements Serializable {
    private final String mcUserName;
    private final Secret mcPassword;
    private final Secret mcExecToken;
    private final String value;
    private AuthType authType;

    @DataBoundConstructor
    public AuthModel(String mcUserName, String mcPassword, String mcExecToken, String value) {
        this.mcUserName = mcUserName;
        this.mcPassword = Secret.fromString((String)mcPassword);
        this.mcExecToken = Secret.fromString((String)mcExecToken);
        this.value = value;
        this.authType = AuthType.fromString(value);
        if (this.authType == AuthType.UNKNOWN) {
            if (StringUtils.isNotBlank((CharSequence)mcExecToken)) {
                this.authType = AuthType.TOKEN;
            } else if (StringUtils.isNotBlank((CharSequence)mcUserName) && StringUtils.isNotBlank((CharSequence)mcPassword)) {
                this.authType = AuthType.BASE;
            }
        }
    }

    public String getMcUserName() {
        return this.mcUserName;
    }

    public String getMcPassword() {
        if (null != this.mcPassword) {
            return this.mcPassword.getPlainText();
        }
        return null;
    }

    public String getMcExecToken() {
        if (null != this.mcExecToken) {
            return this.mcExecToken.getPlainText();
        }
        return null;
    }

    public String getValue() {
        return this.value;
    }

    public String getMcEncryptedExecToken() {
        if (null != this.mcExecToken) {
            return this.mcExecToken.getEncryptedValue();
        }
        return null;
    }

    public String getMcEncryptedPassword() {
        if (null != this.mcPassword) {
            return this.mcPassword.getEncryptedValue();
        }
        return null;
    }

    public AuthType getAuthType() {
        return this.authType;
    }
}

