/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.model;

import com.microfocus.application.automation.tools.model.CredentialsModel;
import com.microfocus.application.automation.tools.model.SSOCredentialsModel;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class AlmServerSettingsModel
extends AbstractDescribableImpl<AlmServerSettingsModel>
implements Comparable<AlmServerSettingsModel> {
    private final String _almServerName;
    private final String _almServerUrl;
    private List<CredentialsModel> _almCredentials;
    private List<SSOCredentialsModel> _almSSOCredentials;

    @DataBoundConstructor
    public AlmServerSettingsModel(String almServerName, String almServerUrl, List<CredentialsModel> almCredentials, List<SSOCredentialsModel> almSSOCredentials) {
        this._almServerName = almServerName.trim();
        this._almServerUrl = almServerUrl.trim();
        this._almCredentials = almCredentials;
        this._almSSOCredentials = almSSOCredentials;
    }

    public String getAlmServerName() {
        return this._almServerName;
    }

    public String getAlmServerUrl() {
        return this._almServerUrl;
    }

    public List<CredentialsModel> getAlmCredentials() {
        if (this._almCredentials != null) {
            return this._almCredentials;
        }
        return new ArrayList<CredentialsModel>();
    }

    public void set_almCredentials(List<CredentialsModel> almCredentials) {
        this._almCredentials = almCredentials;
    }

    public List<SSOCredentialsModel> getAlmSSOCredentials() {
        if (this._almSSOCredentials != null) {
            return this._almSSOCredentials;
        }
        return new ArrayList<SSOCredentialsModel>();
    }

    public void set_almSSOCredentials(List<SSOCredentialsModel> almSSOCredentials) {
        this._almSSOCredentials = almSSOCredentials;
    }

    public Properties getProperties() {
        Properties prop = new Properties();
        if (!StringUtils.isEmpty((String)this._almServerUrl)) {
            prop.put("almServerUrl", this._almServerUrl.trim());
        } else {
            prop.put("almServerUrl", "");
        }
        return prop;
    }

    @Override
    public int compareTo(AlmServerSettingsModel model) {
        return this._almServerName.compareTo(model._almServerName);
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AlmServerSettingsModel> {
        @Nonnull
        public String getDisplayName() {
            return "Alm Server Settings Model";
        }
    }
}

