/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.lr.model;

import com.microfocus.application.automation.tools.lr.Messages;
import com.microfocus.application.automation.tools.lr.model.ScriptRTSModel;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class ScriptRTSSetModel
extends AbstractDescribableImpl<ScriptRTSSetModel> {
    private List<ScriptRTSModel> scripts;

    @DataBoundConstructor
    public ScriptRTSSetModel(List<ScriptRTSModel> scripts) {
        this.scripts = scripts;
    }

    public List<ScriptRTSModel> getScripts() {
        return this.scripts;
    }

    public void addScriptsToProps(Properties props, EnvVars envVars) {
        int scriptCounter = 1;
        ScriptRTSModel.additionalAttributeCounter = 1;
        for (ScriptRTSModel script : this.scripts) {
            if (StringUtils.isEmpty((String)script.getScriptName())) continue;
            props.put("ScriptRTS" + scriptCounter, script.getScriptName());
            script.addAdditionalAttributesToPropsFile(props, script.getScriptName(), envVars);
            ++scriptCounter;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ScriptRTSSetModel> {
        @Nonnull
        public String getDisplayName() {
            return Messages.ScriptRTSSetModel();
        }
    }
}

