/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload.xmlreader;

import com.microfocus.application.automation.tools.commonResultUpload.CommonUploadLogger;
import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.TestSetReader;
import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.model.EntitiesFieldMap;
import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.model.XmlResultEntity;
import hudson.FilePath;
import hudson.model.Result;
import hudson.model.Run;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;

public class XmlReader {
    private CommonUploadLogger logger;
    private Run<?, ?> run;
    private FilePath workspace;

    public XmlReader(Run<?, ?> run, FilePath workspace, CommonUploadLogger logger) {
        this.run = run;
        this.logger = logger;
        this.workspace = workspace;
    }

    public List<XmlResultEntity> scan(String filePath, EntitiesFieldMap entitiesFieldMap) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setBasedir(this.run.getRootDir());
        ds.setIncludes(new String[]{filePath});
        ds.scan();
        if (ds.getIncludedFilesCount() == 0) {
            this.logger.info("No Test Report found in job folder: " + this.run.getRootDir().getAbsolutePath());
            return this.scanInWorkspace(filePath, entitiesFieldMap);
        }
        this.logger.info(ds.getIncludedFilesCount() + " test result file found in job folder: " + this.run.getRootDir().getAbsolutePath());
        return this.readBuildPath(ds.getIncludedFiles(), entitiesFieldMap);
    }

    private List<XmlResultEntity> scanInWorkspace(String filePath, EntitiesFieldMap entitiesFieldMap) {
        ArrayList<FilePath> files = new ArrayList<FilePath>();
        for (String include : new String[]{filePath}) {
            try {
                files.addAll(Arrays.asList(this.workspace.list(include)));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                this.run.setResult(Result.FAILURE);
            }
        }
        if (files.size() < 1) {
            this.logger.info("No Test Report found in workspace: " + String.valueOf(this.workspace));
        }
        this.logger.info(files.size() + " test result file found in workspace: " + String.valueOf(this.workspace));
        return this.readWorkspace(files, entitiesFieldMap);
    }

    private List<XmlResultEntity> readWorkspace(List<FilePath> files, EntitiesFieldMap entitiesFieldMap) {
        ArrayList<XmlResultEntity> xmlResultEntities = new ArrayList<XmlResultEntity>();
        for (FilePath file : files) {
            try {
                TestSetReader tr = new TestSetReader(file, entitiesFieldMap);
                xmlResultEntities.addAll(tr.readTestsets());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                e.printStackTrace();
                this.run.setResult(Result.FAILURE);
            }
        }
        return xmlResultEntities;
    }

    private List<XmlResultEntity> readBuildPath(String[] files, EntitiesFieldMap entitiesFieldMap) {
        ArrayList<XmlResultEntity> xmlResultEntities = new ArrayList<XmlResultEntity>();
        for (String fileName : files) {
            String fullpath = this.run.getRootDir().getAbsolutePath() + File.separator + fileName;
            try {
                TestSetReader tr = new TestSetReader(fullpath, entitiesFieldMap);
                xmlResultEntities.addAll(tr.readTestsets());
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                e.printStackTrace();
                this.run.setResult(Result.FAILURE);
            }
        }
        return xmlResultEntities;
    }
}

