/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload.uploader;

import com.microfocus.application.automation.tools.commonResultUpload.CommonUploadLogger;
import com.microfocus.application.automation.tools.commonResultUpload.service.CustomizationService;
import com.microfocus.application.automation.tools.commonResultUpload.service.RestService;
import com.microfocus.application.automation.tools.commonResultUpload.uploader.RunUploader;
import com.microfocus.application.automation.tools.commonResultUpload.xmlreader.model.XmlResultEntity;
import com.microfocus.application.automation.tools.results.service.AttachmentUploadService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TestInstanceUploader {
    private static final String TEST_CONFIG_PREFIX = "test-configs";
    public static final String TEST_INSTANCE_PREFIX = "test-instances";
    private CommonUploadLogger logger;
    private Map<String, String> params;
    private RestService restService;
    private RunUploader runUploader;
    private CustomizationService customizationService;

    public TestInstanceUploader(CommonUploadLogger logger, Map<String, String> params, RestService restService, RunUploader runUploader, CustomizationService customizationService) {
        this.logger = logger;
        this.params = params;
        this.restService = restService;
        this.runUploader = runUploader;
        this.customizationService = customizationService;
    }

    public void upload(Map<String, String> testset, XmlResultEntity xmlResultEntity, String attachment, boolean isCreateDesStep) {
        List<Map<String, String>> testInstances;
        Map<String, String> test = xmlResultEntity.getValueMap();
        Map<String, String> testconfig = this.getMainTestConfig(test);
        if (testconfig != null && (testInstances = this.getExistTestInstances(testset, test, testconfig)) != null) {
            Map<String, String> testinstance;
            if (testInstances.size() == 0) {
                testinstance = this.buildNewTestInstance(testset, test, testconfig);
                testinstance.putAll(this.restService.create(TEST_INSTANCE_PREFIX, testinstance));
            } else {
                testinstance = testInstances.get(0);
            }
            if (StringUtils.isNotEmpty((String)attachment)) {
                AttachmentUploadService.getInstance().upload(attachment, TEST_INSTANCE_PREFIX, testinstance.get("id"));
            }
            if (xmlResultEntity.getSubEntities().size() > 0) {
                this.runUploader.upload(testset, test, testconfig, testinstance, xmlResultEntity.getSubEntities().get(0).getValueMap(), isCreateDesStep);
            } else {
                this.logger.info("No run is found for test: " + test.get("name"));
            }
        }
    }

    private Map<String, String> buildNewTestInstance(Map<String, String> testset, Map<String, String> test, Map<String, String> testconfig) {
        HashMap<String, String> testinstance = new HashMap<String, String>();
        testinstance.put("subtype-id", this.customizationService.getTestInstanceSubtypeIdByTest(test.get("subtype-id")));
        testinstance.put("cycle-id", String.valueOf(testset.get("id")));
        testinstance.put("test-config-id", String.valueOf(testconfig.get("id")));
        testinstance.put("test-id", String.valueOf(test.get("id")));
        testinstance.put("owner", this.params.get("actualUser"));
        return testinstance;
    }

    private Map<String, String> getMainTestConfig(Map<String, String> test) {
        String queryString = String.format("query={parent-id[%s]}&fields=id,name", String.valueOf(test.get("id")));
        List<Map<String, String>> testconfigs = this.restService.get(null, TEST_CONFIG_PREFIX, queryString);
        if (testconfigs != null && testconfigs.size() > 0) {
            return testconfigs.get(0);
        }
        return null;
    }

    private List<Map<String, String>> getExistTestInstances(Map<String, String> testset, Map<String, String> test, Map<String, String> testconfig) {
        String queryString = String.format("query={cycle-id[%s];test-config-id[%s];test-id[%s]}&fields=id,name,subtype-id", String.valueOf(testset.get("id")), String.valueOf(testconfig.get("id")), String.valueOf(test.get("id")));
        return this.restService.get(null, TEST_INSTANCE_PREFIX, queryString);
    }
}

