/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload.service;

import com.microfocus.application.automation.tools.commonResultUpload.CommonUploadLogger;
import com.microfocus.application.automation.tools.rest.RestClient;
import com.microfocus.application.automation.tools.sse.sdk.ResourceAccessLevel;
import com.microfocus.application.automation.tools.sse.sdk.Response;

public class VersionControlService {
    public static final String CHECK_IN = "check-in";
    public static final String CHECK_OUT = "check-out";
    public static final String CHECK_UNDO_CHECK_OUT = "undo-check-out";
    private RestClient client;
    private CommonUploadLogger logger;

    public VersionControlService(RestClient client, CommonUploadLogger logger) {
        this.client = client;
        this.logger = logger;
    }

    public boolean refreshEntityVersion(String restPrefix, String entityId) {
        boolean result = false;
        result = this.versionsCheck(restPrefix, entityId, CHECK_OUT);
        if (!result) {
            return false;
        }
        return this.versionsCheck(restPrefix, entityId, CHECK_UNDO_CHECK_OUT);
    }

    public boolean versionsCheck(String restPrefix, String entityId, String operation) {
        String suffix = String.format("%s/%s/versions/%s", restPrefix, entityId, operation);
        String url = this.client.buildRestRequest(suffix);
        Response response = this.client.httpPost(url, null, null, ResourceAccessLevel.PROTECTED);
        if (!response.isOk()) {
            this.logger.error(String.format("%s entity failed. %s(%s)", operation, restPrefix, entityId));
            this.logger.error(response.getFailure().toString());
            return false;
        }
        return true;
    }
}

