/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload.service;

import com.microfocus.application.automation.tools.results.service.AlmRestTool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CriteriaTranslator {
    public static final String CRITERIA_PREFIX = "q|";

    private CriteriaTranslator() {
    }

    public static String getCriteriaString(String[] fields, Map<String, String> entity) {
        ArrayList<String> tobeRemoved = new ArrayList<String>();
        HashMap<String, String> tobeAdded = new HashMap<String, String>();
        StringBuilder sb = new StringBuilder();
        sb.append("fields=");
        for (int i = 0; i < fields.length; ++i) {
            sb.append(fields[i]);
            if (i >= fields.length - 1) continue;
            sb.append(",");
        }
        sb.append("&query={");
        for (Map.Entry<String, String> entry : entity.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(CRITERIA_PREFIX)) continue;
            tobeRemoved.add(key);
            String realName = key.substring(key.indexOf(CRITERIA_PREFIX) + CRITERIA_PREFIX.length());
            tobeAdded.put(realName, entity.get(key));
            sb.append(realName).append("[").append(AlmRestTool.getEncodedString(entity.get(key))).append("]").append(";");
        }
        if (tobeRemoved.size() == 0) {
            sb.append("name").append("[").append(AlmRestTool.getEncodedString(entity.get("name"))).append("];");
        }
        sb.append("}");
        entity.putAll(tobeAdded);
        for (String item : tobeRemoved) {
            entity.remove(item);
        }
        return sb.toString();
    }
}

