/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools.commonResultUpload.rest;

import com.microfocus.application.automation.tools.commonResultUpload.CommonUploadLogger;
import com.microfocus.application.automation.tools.rest.RestClient;
import com.microfocus.application.automation.tools.sse.common.RestXmlUtils;
import com.microfocus.application.automation.tools.sse.common.XPathUtils;
import com.microfocus.application.automation.tools.sse.sdk.Response;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;

public abstract class BasicPostEntityRequest {
    private static final String START = "<Title>";
    private static final String END = "</Title>";
    private static final String IGNORE_REQUIRED_FIELDS_VALIDATION = "X-QC-Ignore-Customizable-Required-Fields-Validation";
    private static final String X_XSRF_TOKEN = "X-XSRF-TOKEN";
    protected RestClient client;
    protected CommonUploadLogger logger;
    protected String operation;

    protected BasicPostEntityRequest(RestClient client, CommonUploadLogger logger, String operation) {
        this.client = client;
        this.logger = logger;
        this.operation = operation;
    }

    public abstract Map<String, String> perform(String var1, Map<String, String> var2);

    protected Map<String, String> getHeaders() {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("Content-Type", "application/xml");
        ret.put("Accept", "application/xml");
        ret.put(IGNORE_REQUIRED_FIELDS_VALIDATION, "Y");
        ret.put(X_XSRF_TOKEN, this.client.getXsrfTokenValue());
        return ret;
    }

    private String getRestErrorMessage(String responseContent) {
        return responseContent.substring(responseContent.indexOf(START) + START.length(), responseContent.indexOf(END));
    }

    protected byte[] getDataBytes(Map<String, String> valueMap) {
        StringBuilder builder = new StringBuilder("<Entity><Fields>");
        for (Map.Entry<String, String> entry : valueMap.entrySet()) {
            builder.append(RestXmlUtils.fieldXml(entry.getKey(), StringEscapeUtils.escapeXml10((String)entry.getValue())));
        }
        builder.append("</Fields></Entity>");
        this.logger.info("Request body: " + builder.toString());
        return builder.toString().getBytes();
    }

    private String getResultNameAndId(Map<String, String> result) {
        return "id:" + result.get("id") + ", name:" + result.get("name");
    }

    protected Map<String, String> handleResult(Response response, Map<String, String> valueMap, String restPrefix) {
        if (response.isOk() && !response.toString().equals("")) {
            Map<String, String> result = XPathUtils.toEntities(response.toString()).get(0);
            this.logger.info(String.format("%s entity success. %s(%s)", this.operation, restPrefix, this.getResultNameAndId(result)));
            return result;
        }
        this.logger.error(String.format("%s entity failed. %s(%s)", this.operation, restPrefix, this.getResultNameAndId(valueMap)));
        this.logger.error(response.getFailure().toString());
        this.logger.error(this.getRestErrorMessage(response.toString()));
        return null;
    }

    protected Map<String, Map<String, String>> bulkCreate(String restPrefix, Map<String, Map<String, String>> valueMap) {
        return null;
    }
}

