/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools;

import com.microfocus.application.automation.tools.common.Pair;
import com.microfocus.application.automation.tools.nodes.EncryptionNodeProperty;
import com.microfocus.application.automation.tools.settings.UFTEncryptionGlobalConfiguration;
import com.microfocus.application.automation.tools.sse.common.StringUtils;
import hudson.FilePath;
import hudson.model.Node;
import hudson.util.Secret;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;

public final class EncryptionUtils {
    private static final int KEY_SIZE = 3072;
    private static final String ENC_TYPE_FOR_PROPS = "RSA";
    private static final String ENC_TYPE_FOR_NODE = "AES/CBC/PKCS7Padding";
    private static final String PRIVATE_SPEC_FOR_NODE = "AES";
    private static final String KEY_PATH = "secrets/.hptoolslaunchersecret.key";
    private static final String NL = System.getProperty("line.separator");

    private EncryptionUtils() {
    }

    private static PublicKey tryParsePublicKey(String publicKeyStr) throws EncryptionException {
        PublicKey publicKey;
        KeyFactory keyFactory;
        try {
            keyFactory = KeyFactory.getInstance(ENC_TYPE_FOR_PROPS);
        }
        catch (NoSuchAlgorithmException ignored) {
            throw new EncryptionException("Failed to get key factory.");
        }
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(Base64.getDecoder().decode(publicKeyStr.replace("\n", "").getBytes(StandardCharsets.UTF_8)));
        try {
            publicKey = keyFactory.generatePublic(publicKeySpec);
        }
        catch (InvalidKeySpecException ignored) {
            throw new EncryptionException("Failed to regenerate public key.");
        }
        return publicKey;
    }

    private static Pair<PublicKey, PrivateKey> generatePair() throws EncryptionException {
        KeyPairGenerator generator;
        try {
            generator = KeyPairGenerator.getInstance(ENC_TYPE_FOR_PROPS);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Failed to get key pair generator.");
        }
        generator.initialize(3072);
        KeyPair pair = generator.generateKeyPair();
        return new Pair<PublicKey, PrivateKey>(pair.getPublic(), pair.getPrivate());
    }

    private static String getBase64(byte[] bytes) {
        return Base64.getEncoder().encodeToString(bytes);
    }

    private static String getPublicKeyEncoded(PublicKey publicKey) {
        return EncryptionUtils.getBase64(publicKey.getEncoded());
    }

    static byte[] getBytes(BigInteger bigInt) {
        byte[] bytes = bigInt.toByteArray();
        int length = bytes.length;
        if (length % 2 != 0 && bytes[0] == 0) {
            bytes = Arrays.copyOfRange(bytes, 1, length);
        }
        return bytes;
    }

    private static String getElement(String name, BigInteger bigInt) {
        String cnt = EncryptionUtils.getBase64(EncryptionUtils.getBytes(bigInt));
        return String.format("<%s>%s</%s>%s", name, cnt, name, NL);
    }

    private static String convertPrivateKeyToXMLFormat(PrivateKey key) throws EncryptionException {
        RSAPrivateCrtKeySpec spec;
        KeyFactory keyFactory;
        try {
            keyFactory = KeyFactory.getInstance(ENC_TYPE_FOR_PROPS);
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Failed to get key factory.");
        }
        try {
            spec = keyFactory.getKeySpec(key, RSAPrivateCrtKeySpec.class);
        }
        catch (InvalidKeySpecException e) {
            throw new EncryptionException("Failed to create specification for private key.");
        }
        return "<RSAKeyValue>" + NL + EncryptionUtils.getElement("Modulus", spec.getModulus()) + EncryptionUtils.getElement("Exponent", spec.getPublicExponent()) + EncryptionUtils.getElement("P", spec.getPrimeP()) + EncryptionUtils.getElement("Q", spec.getPrimeQ()) + EncryptionUtils.getElement("DP", spec.getPrimeExponentP()) + EncryptionUtils.getElement("DQ", spec.getPrimeExponentQ()) + EncryptionUtils.getElement("InverseQ", spec.getCrtCoefficient()) + EncryptionUtils.getElement("D", spec.getPrivateExponent()) + "</RSAKeyValue>";
    }

    private static void savePrivateKeyForNode(FilePath root, PrivateKey key) throws EncryptionException {
        Secret sk;
        try {
            sk = Secret.fromString((String)UFTEncryptionGlobalConfiguration.getInstance().getEncKey());
        }
        catch (NullPointerException ignored) {
            throw new EncryptionException("Jenkins cannot find the module for encryption secret key.");
        }
        String privateKey = EncryptionUtils.convertPrivateKeyToXMLFormat(key);
        String encrypted = EncryptionUtils.encryptWithPwd(privateKey, sk.getPlainText());
        InputStream encryptedAsStream = IOUtils.toInputStream((String)encrypted, (Charset)StandardCharsets.UTF_8);
        try {
            root.child(KEY_PATH).copyFrom(encryptedAsStream);
        }
        catch (IOException | InterruptedException e) {
            throw new EncryptionException("Failed to save private key to executor node: " + e.getMessage() + ".");
        }
    }

    public static String encrypt(String text, Node currNode) throws EncryptionException {
        PublicKey publicKey;
        EncryptionNodeProperty publicKeyProp = (EncryptionNodeProperty)currNode.getNodeProperty(EncryptionNodeProperty.class);
        if (publicKeyProp == null) {
            currNode.getNodeProperties().add((Object)new EncryptionNodeProperty());
            publicKeyProp = (EncryptionNodeProperty)currNode.getNodeProperty(EncryptionNodeProperty.class);
        }
        if (publicKeyProp == null) {
            throw new EncryptionException("You need to enable encryption in Node configuration manually first, automatic addition failed before running Functional Testing tests.");
        }
        String publicKeyStr = Secret.fromString((String)publicKeyProp.getPublicKey()).getPlainText();
        if (StringUtils.isNullOrEmpty(publicKeyStr)) {
            Pair<PublicKey, PrivateKey> encPair;
            try {
                encPair = EncryptionUtils.generatePair();
            }
            catch (EncryptionException ignored) {
                throw new EncryptionException("Failed to generate key pairs for encryption.");
            }
            publicKey = encPair.getFirst();
            publicKeyStr = EncryptionUtils.getPublicKeyEncoded(publicKey);
            EncryptionUtils.savePrivateKeyForNode(currNode.getRootPath(), encPair.getSecond());
            publicKeyProp.setPublicKey(publicKeyStr);
            try {
                currNode.save();
            }
            catch (IOException e) {
                throw new EncryptionException("Failed to save public key on executor node: " + e.getMessage() + ".");
            }
        }
        publicKey = EncryptionUtils.tryParsePublicKey(publicKeyStr);
        return EncryptionUtils.encrypt(text, publicKey);
    }

    public static String encrypt(String text, PublicKey publicKey) throws EncryptionException {
        byte[] encryptedBytes;
        Cipher encryptCipher;
        try {
            encryptCipher = Cipher.getInstance(ENC_TYPE_FOR_PROPS);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException ignored) {
            throw new EncryptionException("Failed to obtain RSA cipher.");
        }
        try {
            encryptCipher.init(1, publicKey);
        }
        catch (InvalidKeyException ignored) {
            throw new EncryptionException("Failed to initialize RSA cipher.");
        }
        byte[] plainBytes = text.getBytes(StandardCharsets.UTF_8);
        try {
            encryptedBytes = encryptCipher.doFinal(plainBytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException ignored) {
            throw new EncryptionException("Failed to encrypt data.");
        }
        return EncryptionUtils.getBase64(encryptedBytes);
    }

    private static String encryptWithPwd(String text, String pwd) throws EncryptionException {
        byte[] encrypted;
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(ENC_TYPE_FOR_NODE);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException ignored) {
            throw new EncryptionException("Failed to obtain AES/CBC/PKCS7Padding cipher.");
        }
        SecretKeySpec keySpec = new SecretKeySpec(pwd.getBytes(StandardCharsets.UTF_8), PRIVATE_SPEC_FOR_NODE);
        try {
            cipher.init(1, (Key)keySpec, new SecureRandom());
        }
        catch (InvalidKeyException ignored) {
            throw new EncryptionException("Failed to initialize AES/CBC/PKCS7Padding cipher.");
        }
        try {
            encrypted = cipher.doFinal(text.getBytes(StandardCharsets.UTF_8));
        }
        catch (BadPaddingException | IllegalBlockSizeException ignored) {
            throw new EncryptionException("Failed to encrypt data.");
        }
        byte[] ivBytes = cipher.getIV();
        byte[] combined = new byte[ivBytes.length + encrypted.length];
        System.arraycopy(ivBytes, 0, combined, 0, ivBytes.length);
        System.arraycopy(encrypted, 0, combined, ivBytes.length, encrypted.length);
        return EncryptionUtils.getBase64(combined);
    }

    public static class EncryptionException
    extends Exception {
        public EncryptionException(String message) {
            super(message);
        }

        @Override
        public String getMessage() {
            return super.getMessage();
        }
    }
}

