/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.application.automation.tools;

import com.microfocus.application.automation.tools.JenkinsUtils;
import com.microfocus.application.automation.tools.settings.UFTEncryptionGlobalConfiguration;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.Node;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import hudson.util.Secret;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public final class AlmToolsUtils {
    private AlmToolsUtils() {
    }

    public static void runOnBuildEnv(Run<?, ?> build, Launcher launcher, TaskListener listener, FilePath file, String paramFileName, Node node) throws IOException, InterruptedException {
        AlmToolsUtils.runOnBuildEnv(build, launcher, listener, file, paramFileName, node, "UTF-8");
    }

    public static void runOnBuildEnv(Run<?, ?> build, Launcher launcher, TaskListener listener, FilePath file, String paramFileName, Node node, String encoding) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        PrintStream out = listener.getLogger();
        args.add((Object)file);
        args.add("-paramfile");
        args.add(paramFileName);
        if (StringUtils.isNotBlank((String)encoding)) {
            args.add("-encoding");
            args.add(encoding);
        }
        HashMap<String, String> envs = new HashMap<String, String>();
        try {
            UFTEncryptionGlobalConfiguration config = UFTEncryptionGlobalConfiguration.getInstance();
            envs.put("hptoolslauncher.key", Secret.fromString((String)config.getEncKey()).getPlainText());
        }
        catch (NullPointerException ignored) {
            throw new IOException("Failed to access encryption key, the module UFTEncryption is unavailable.");
        }
        if (node == null && (node = JenkinsUtils.getCurrentNode(file)) == null) {
            throw new IOException("Failed to access current executor node.");
        }
        try {
            envs.put("hptoolslauncher.rootpath", Objects.requireNonNull(node.getRootPath()).getRemote());
        }
        catch (NullPointerException e) {
            throw new IOException(e.getMessage());
        }
        int returnCode = launcher.launch().cmds(args).stdout((OutputStream)out).pwd(file.getParent()).envs(envs).join();
        if (returnCode != 0) {
            if (returnCode == -1) {
                build.setResult(Result.FAILURE);
            } else if (returnCode == -2) {
                build.setResult(Result.UNSTABLE);
            } else {
                if (returnCode == -3) {
                    build.setResult(Result.ABORTED);
                    throw new InterruptedException();
                }
                listener.getLogger().println("Launch return code " + returnCode);
                build.setResult(Result.FAILURE);
                if (returnCode == -2146232576 && file.getRemote().toLowerCase(Locale.ROOT).contains("\\system32\\config")) {
                    listener.getLogger().println("!!! Move 'JENKINS_HOME' out of the 'windows\\\\system32' folder because the plugin may not have permissions to launch tests under this folder.");
                }
            }
        }
    }

    public static void runHpToolsAborterOnBuildEnv(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener, String paramFileName) throws IOException, InterruptedException {
        AlmToolsUtils.runHpToolsAborterOnBuildEnv(build, launcher, (TaskListener)listener, paramFileName, build.getWorkspace());
    }

    public static void runHpToolsAborterOnBuildEnv(Run<?, ?> build, Launcher launcher, TaskListener listener, String paramFileName, FilePath runWorkspace) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        PrintStream out = listener.getLogger();
        String hpToolsAborter_exe = "HpToolsAborter.exe";
        URL hpToolsAborterUrl = Jenkins.get().pluginManager.uberClassLoader.getResource("HpToolsAborter.exe");
        FilePath hpToolsAborterFile = runWorkspace.child(hpToolsAborter_exe);
        args.add((Object)hpToolsAborterFile);
        args.add(paramFileName);
        hpToolsAborterFile.copyFrom(hpToolsAborterUrl);
        int returnCode = launcher.launch().cmds(args).stdout((OutputStream)out).pwd(hpToolsAborterFile.getParent()).join();
        try {
            hpToolsAborterFile.delete();
        }
        catch (Exception e) {
            listener.error("failed copying HpToolsAborter: " + String.valueOf(e));
        }
        if (returnCode != 0) {
            if (returnCode == 1) {
                build.setResult(Result.FAILURE);
            } else if (returnCode == 2) {
                build.setResult(Result.UNSTABLE);
            } else if (returnCode == 3) {
                build.setResult(Result.ABORTED);
            }
        }
    }

    public static boolean tryCreatePropsFile(TaskListener listener, String props, FilePath fileProps) throws InterruptedException, IOException {
        if (StringUtils.isBlank((String)props)) {
            listener.fatalError("Missing properties text content.");
            return false;
        }
        if (fileProps.exists() && fileProps.length() > 0L) {
            listener.getLogger().println(String.format("NOTE: The file [%s] already exists.", fileProps.getRemote()));
        }
        String msg = String.format("Trying to create or replace the file [%s] ...", fileProps.getRemote());
        listener.getLogger().println(msg);
        return AlmToolsUtils.trySaveAndCheckPropsFile(listener, props, fileProps, 0);
    }

    private static boolean trySaveAndCheckPropsFile(TaskListener listener, String props, FilePath fileProps, int idxOfRetry) throws InterruptedException {
        boolean ok = false;
        try {
            try (InputStream in = IOUtils.toInputStream((String)props, (Charset)StandardCharsets.UTF_8);){
                fileProps.copyFrom(in);
            }
            Thread.sleep(1500L);
            if (fileProps.exists() && fileProps.length() > 0L) {
                String msg = "Successfully created the file";
                if (idxOfRetry == 0) {
                    listener.getLogger().println(String.format("%s [%s].", msg, fileProps.getName()));
                } else {
                    listener.getLogger().println(String.format("%s after %d %s.", msg, idxOfRetry, idxOfRetry == 1 ? "retry" : "retries"));
                }
                ok = true;
            } else if (idxOfRetry > 5) {
                listener.fatalError("Failed to save the file " + fileProps.getName() + " after 5 retries.");
            } else {
                ok = AlmToolsUtils.trySaveAndCheckPropsFile(listener, props, fileProps, ++idxOfRetry);
            }
        }
        catch (IOException ioe) {
            if (idxOfRetry > 5) {
                listener.fatalError("Failed to save the file " + fileProps.getName() + " after 5 retries: " + ioe.getMessage());
            }
            Thread.sleep(1500L);
            ok = AlmToolsUtils.trySaveAndCheckPropsFile(listener, props, fileProps, ++idxOfRetry);
        }
        return ok;
    }

    public static String getPropsAsString(Properties props) throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            props.store(stream, "");
            String string = ((Object)stream).toString();
            return string;
        }
    }
}

