/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.dto.scm;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum SCMType {
    UNKNOWN("unknown", 0),
    GIT("git", 2),
    SVN("svn", 1),
    STARTEAM("starteam", 3),
    ACCUREV("accurev", 4),
    DIMENSIONS_CM("dimensions_cm", 5),
    EXTERNAL_STORAGE("external_storage", 6);

    private String value;
    private int octaneId;

    private SCMType(String typeName, int octaneId) {
        this.value = typeName;
        this.octaneId = octaneId;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static SCMType fromValue(String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("value MUST NOT be null nor empty");
        }
        SCMType result = UNKNOWN;
        for (SCMType v : SCMType.values()) {
            if (v.value.compareTo(value) != 0) continue;
            result = v;
            break;
        }
        return result;
    }

    public int getOctaneId() {
        return this.octaneId;
    }
}

