/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.dto.coverage.impl;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.hp.octane.integrations.dto.coverage.BuildCoverage;
import com.hp.octane.integrations.dto.coverage.FileCoverage;
import com.hp.octane.integrations.dto.coverage.impl.FileCoverageImpl;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BuildCoverageImpl
implements BuildCoverage {
    private List<FileCoverage> fileCoverageList = new ArrayList<FileCoverage>();
    private Integer sumOfCoveredLines;
    private Integer totalCoverableLines;
    private String projectName;

    @Override
    public List<FileCoverage> getFileCoverageList() {
        return this.fileCoverageList;
    }

    @Override
    public BuildCoverage setFileCoverageList(List<FileCoverage> fileCoverageList) {
        this.fileCoverageList = fileCoverageList;
        return this;
    }

    @Override
    public Integer getSumOfCoveredLines() {
        return this.sumOfCoveredLines;
    }

    @Override
    public BuildCoverage setSumOfCoveredLines(Integer sumOfCoveredLines) {
        this.sumOfCoveredLines = sumOfCoveredLines;
        return this;
    }

    @Override
    public Integer getTotalCoverableLines() {
        return this.totalCoverableLines;
    }

    @Override
    public BuildCoverage setTotalCoverableLines(Integer totalCoverableLines) {
        this.totalCoverableLines = totalCoverableLines;
        return this;
    }

    @Override
    public String getProjectName() {
        return this.projectName;
    }

    @Override
    public BuildCoverage setProjectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    @Override
    public BuildCoverage mergeSonarCoverageReport(JsonNode jsonReport) {
        if (this.projectName == null) {
            JsonNode baseComponentJson = jsonReport.get("baseComponent");
            this.projectName = baseComponentJson.get("name").textValue();
            JsonNode measuresArray = baseComponentJson.get("measures");
            this.totalCoverableLines = this.getIntegerValueFromMeasuresArray("lines_to_cover", measuresArray);
            Integer uncoveredLines = this.getIntegerValueFromMeasuresArray("uncovered_lines", measuresArray);
            this.sumOfCoveredLines = this.totalCoverableLines - uncoveredLines;
        }
        ArrayNode componentsArray = (ArrayNode)jsonReport.get("components");
        for (JsonNode component : componentsArray) {
            FileCoverage fileCoverage = this.getFileCoverageFromJson(component);
            this.fileCoverageList.add(fileCoverage);
        }
        return this;
    }

    private FileCoverage getFileCoverageFromJson(JsonNode fileComponent) {
        JsonNode measuresArray = fileComponent.get("measures");
        Integer linesToCover = this.getIntegerValueFromMeasuresArray("lines_to_cover", measuresArray);
        Integer uncoveredLines = this.getIntegerValueFromMeasuresArray("uncovered_lines", measuresArray);
        return new FileCoverageImpl().setPath(fileComponent.get("path").textValue()).setSumOfCoveredLines(linesToCover - uncoveredLines).setTotalCoverableLines(linesToCover);
    }

    private Integer getIntegerValueFromMeasuresArray(String metric, JsonNode measures) {
        for (JsonNode measure : measures) {
            if (!measure.get("metric").textValue().equals(metric)) continue;
            return Integer.parseInt(measure.get("value").textValue());
        }
        return 0;
    }
}

