/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.dto.connectivity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum HttpMethod {
    POST("POST"),
    GET("GET"),
    PUT("PUT"),
    DELETE("DELETE");

    private String value;

    private HttpMethod(String status) {
        this.value = status;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static HttpMethod fromValue(String value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("value MUST NOT be null nor empty");
        }
        HttpMethod result = null;
        for (HttpMethod v : HttpMethod.values()) {
            if (!v.value.equalsIgnoreCase(value)) continue;
            result = v;
            break;
        }
        if (result == null) {
            throw new IllegalStateException("method '" + value + "' is not supported");
        }
        return result;
    }
}

