/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.adm.performancecenter.plugins.common.rest;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.AuthenticationClient;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcErrorResponse;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcException;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunEventLog;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunRequest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunResponse;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcRunResults;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcScript;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcScripts;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestData;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestInstances;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestPlanFolder;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestPlanFolders;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTestSets;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTrendReportMetaData;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.PcTrendedRun;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.ReleaseTimeslot;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.ScriptCreateRequest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TestInstanceCreateRequest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TestPlanFolderCreateRequest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TimeslotDuration;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.Timeslots;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TrendReportRequest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.TrendReportTransactionDataRoot;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.Test;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.pcsubentities.test.content.Content;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.simplifiedentities.simplifiedtest.SimplifiedTest;
import com.microfocus.adm.performancecenter.plugins.common.pcentities.simplifiedentities.simplifiedtest.content.SimplifiedContent;
import com.microfocus.adm.performancecenter.plugins.common.utils.Base64Encoder;
import com.microfocus.adm.performancecenter.plugins.common.utils.ConvertContentStringToTest;
import com.microfocus.adm.performancecenter.plugins.common.utils.Helper;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.xml.sax.SAXException;

public class PcRestProxy {
    public static final String PC_API_XMLNS = "http://www.hp.com/PC/REST/API";
    protected static final String BASE_PC_API_URL = "%s://%s/LoadTest/rest";
    protected static final String BASE_PC_API_AUTHENTICATION_URL = "%s://%s/LoadTest/rest/authentication-point";
    protected static final String AUTHENTICATION_LOGIN_URL = "%s://%s/LoadTest/rest/authentication-point/authenticate";
    protected static final String AUTHENTICATION_WITH_TOKEN_LOGIN_URL = "%s://%s/LoadTest/rest/authentication-point/authenticateclient";
    protected static final String AUTHENTICATION_LOGOUT_URL = "%s://%s/LoadTest/rest/authentication-point/logout";
    protected static final String PC_API_RESOURCES_TEMPLATE = "%s://%s/LoadTest/rest/domains/%s/projects/%s";
    protected static final String RUNS_RESOURCE_NAME = "Runs";
    protected static final String TESTS_RESOURCE_NAME = "tests";
    protected static final String TEST_INSTANCES_NAME = "testinstances";
    protected static final String TEST_SETS_NAME = "testsets";
    protected static final String RESULTS_RESOURCE_NAME = "Results";
    protected static final String EVENTLOG_RESOURCE_NAME = "EventLog";
    protected static final String TREND_REPORT_RESOURCE_NAME = "TrendReports";
    protected static final String TREND_REPORT_RESOURCE_SUFFIX = "data";
    protected static final String CONTENT_TYPE_XML = "application/xml";
    protected static final String SCRIPTS_RESOURCE_NAME = "Scripts";
    protected static final String TESTPLAN_RESOURCE_NAME = "testplan";
    protected static final String TIMESLOTS = "timeslots";
    protected static final List<Integer> validStatusCodes = Arrays.asList(200, 201, 202, 204);
    private final String baseURL;
    private final String pcServer;
    private final String webProtocol;
    private String proxyScheme;
    private String proxyHostName;
    private int proxyPort;
    private final CloseableHttpClient client;
    private final HttpContext context;
    private final String tenantSuffix;
    private final boolean authenticateWithToken;

    public PcRestProxy(String webProtocolName, String pcServerName, boolean authenticateWithToken, String almDomain, String almProject, String proxyOutURL, String proxyUser, String proxyPassword) throws PcException {
        String[] lreServerAndTenant = Helper.getLreServerAndTenant(pcServerName);
        this.pcServer = lreServerAndTenant[0];
        this.tenantSuffix = lreServerAndTenant[1];
        this.webProtocol = webProtocolName;
        this.baseURL = String.format(PC_API_RESOURCES_TEMPLATE, this.webProtocol, this.pcServer, almDomain, almProject);
        this.authenticateWithToken = authenticateWithToken;
        PoolingHttpClientConnectionManager cxMgr = new PoolingHttpClientConnectionManager();
        cxMgr.setMaxTotal(100);
        cxMgr.setDefaultMaxPerRoute(20);
        HttpClientBuilder builder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)cxMgr);
        if (proxyOutURL != null && !proxyOutURL.isEmpty()) {
            this.getProxyDataFromURL(proxyOutURL);
            HttpHost proxy = new HttpHost(this.proxyHostName, this.proxyPort, this.proxyScheme);
            RequestConfig config = RequestConfig.custom().setProxy(proxy).build();
            builder.setDefaultRequestConfig(config);
            if (proxyUser != null && !proxyUser.isEmpty()) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(this.proxyHostName, this.proxyPort), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
        }
        this.client = builder.build();
        this.context = new BasicHttpContext();
        BasicCookieStore cookieStore = new BasicCookieStore();
        this.context.setAttribute("http.cookie-store", (Object)cookieStore);
    }

    public static Content getContentFromXmlOrYamlString(String xmlOrYamlTest) {
        Content content = null;
        try {
            Test test = Test.xmlToObject(xmlOrYamlTest);
            content = test.getContent();
        }
        catch (Exception ex) {
            content = Content.xmlToObject(xmlOrYamlTest);
        }
        return content;
    }

    public static boolean isOk(HttpResponse response) {
        return validStatusCodes.contains(response.getStatusLine().getStatusCode());
    }

    public static SimplifiedContent xmlOrYamlStringToSimplifiedContent(String strSimplifiedContent) throws IOException {
        SimplifiedContent simplifiedContent;
        if (strSimplifiedContent == null || strSimplifiedContent.isEmpty()) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            simplifiedContent = (SimplifiedContent)mapper.readValue(strSimplifiedContent, SimplifiedContent.class);
        }
        catch (Exception ex1) {
            try {
                simplifiedContent = SimplifiedContent.xmlToObject(strSimplifiedContent);
            }
            catch (Exception ex2) {
                throw ex1;
            }
        }
        return simplifiedContent;
    }

    public static SimplifiedTest xmlOrYamlStringToSimplifiedTest(String strSimplifiedTest) throws IOException {
        SimplifiedTest simplifiedTest;
        if (strSimplifiedTest == null || strSimplifiedTest.isEmpty()) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            simplifiedTest = (SimplifiedTest)mapper.readValue(strSimplifiedTest, SimplifiedTest.class);
        }
        catch (Exception ex1) {
            try {
                simplifiedTest = SimplifiedTest.xmlToObject(strSimplifiedTest);
            }
            catch (Exception ex2) {
                throw ex1;
            }
        }
        return simplifiedTest;
    }

    private void getProxyDataFromURL(String proxyURL) throws PcException {
        try {
            String mainStr = "";
            if (proxyURL != null && !proxyURL.isEmpty()) {
                String[] urlSplit = proxyURL.split("://");
                this.proxyScheme = urlSplit[0];
                mainStr = urlSplit[1];
                if (mainStr.contains(":")) {
                    this.proxyHostName = mainStr.split(":")[0];
                    this.proxyPort = Integer.parseInt(mainStr.split(":")[1]);
                } else {
                    this.proxyHostName = mainStr;
                    this.proxyPort = 80;
                }
            }
        }
        catch (Exception ex) {
            throw new PcException("Error: Validating Proxy URL: " + ex + " Please add a proxy URL in this pattern: http(s)://<host>:<port> or leave blank");
        }
    }

    public boolean authenticate(String userName, String password) throws PcException, ClientProtocolException, IOException {
        if (this.authenticateWithToken) {
            return this.authenticateWithToken(userName, password);
        }
        return this.authenticateWithoutToken(userName, password);
    }

    private boolean authenticateWithoutToken(String userName, String password) throws PcException, ClientProtocolException, IOException {
        String userNameAndPassword = userName + ":" + password;
        String encodedCredentials = Base64Encoder.encode(userNameAndPassword.getBytes());
        HttpGet authRequest = new HttpGet(String.format(AUTHENTICATION_LOGIN_URL + this.tenantSuffix, this.webProtocol, this.pcServer));
        authRequest.addHeader("Authorization", String.format("Basic %s", encodedCredentials));
        this.executeRequest((HttpRequestBase)authRequest);
        return true;
    }

    private boolean authenticateWithToken(String idKey, String secretKey) throws PcException, ClientProtocolException, IOException {
        AuthenticationClient authenticationClient = new AuthenticationClient(idKey, secretKey);
        HttpPost authRequestWithToken = new HttpPost(String.format(AUTHENTICATION_WITH_TOKEN_LOGIN_URL + this.tenantSuffix, this.webProtocol, this.pcServer));
        authRequestWithToken.addHeader("Content-Type", CONTENT_TYPE_XML);
        authRequestWithToken.setEntity((HttpEntity)new StringEntity(authenticationClient.objectToXML(), ContentType.APPLICATION_XML));
        this.executeRequest((HttpRequestBase)authRequestWithToken);
        return true;
    }

    public PcRunResponse startRun(int testId, int testInstanceId, TimeslotDuration timeslotDuration, String postRunAction, boolean vudsMode, int timeslot) throws PcException, IOException {
        HttpPost request = new HttpPost(String.format(this.baseURL + "/%s", RUNS_RESOURCE_NAME));
        request.addHeader("Content-Type", CONTENT_TYPE_XML);
        PcRunRequest runRequestData = new PcRunRequest(testId, testInstanceId, timeslot, timeslotDuration, postRunAction, vudsMode);
        request.setEntity((HttpEntity)new StringEntity(runRequestData.objectToXML(), ContentType.APPLICATION_XML));
        String responseXml = this.executeRequest((HttpRequestBase)request);
        return PcRunResponse.xmlToObject(responseXml);
    }

    public int createTestInstance(int testId, int testSetId) throws PcException, IOException {
        int testInstanceID;
        HttpPost request = new HttpPost(String.format(this.baseURL + "/%s", TEST_INSTANCES_NAME));
        TestInstanceCreateRequest createRequest = new TestInstanceCreateRequest(testId, testSetId);
        request.setEntity((HttpEntity)new StringEntity(createRequest.objectToXML(), ContentType.APPLICATION_XML));
        request.addHeader("Content-Type", CONTENT_TYPE_XML);
        String responseXml = this.executeRequest((HttpRequestBase)request);
        try {
            testInstanceID = createRequest.getTestInstanceIDFromResponse(responseXml, "TestInstanceID");
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new PcException("createTestInstance exception: " + e, e);
        }
        return testInstanceID;
    }

    @Deprecated
    public PcTestSets GetAllTestSets() throws IOException, PcException {
        return this.getAllTestSets();
    }

    public PcTestSets getAllTestSets() throws IOException, PcException {
        String getTestSetsUrl = String.format(this.baseURL + "/%s", TEST_SETS_NAME);
        HttpGet request = new HttpGet(getTestSetsUrl);
        String testSetsXml = this.executeRequest((HttpRequestBase)request);
        return PcTestSets.xmlToObject(testSetsXml);
    }

    public PcTestInstances getTestInstancesByTestId(int testId) throws PcException, IOException {
        String uri = String.format(this.baseURL + "/%s?%s=%s", TEST_INSTANCES_NAME, "query", URLEncoder.encode("{test-id[" + testId + "]}", "UTF-8"));
        HttpGet request = new HttpGet(uri);
        String testInstancesXml = this.executeRequest((HttpRequestBase)request);
        return PcTestInstances.xmlToObject(testInstancesXml);
    }

    public boolean stopRun(int runId, String stopMode) throws PcException, ClientProtocolException, IOException {
        String stopUrl = String.format(this.baseURL + "/%s/%s/%s", RUNS_RESOURCE_NAME, runId, stopMode);
        HttpPost stopRunRequest = new HttpPost(stopUrl);
        ReleaseTimeslot releaseTimesloteRequest = new ReleaseTimeslot(true, "Do Not Collate");
        stopRunRequest.addHeader("Content-Type", CONTENT_TYPE_XML);
        stopRunRequest.setEntity((HttpEntity)new StringEntity(releaseTimesloteRequest.objectToXML(), ContentType.APPLICATION_XML));
        this.executeRequest((HttpRequestBase)stopRunRequest);
        return true;
    }

    public PcRunResponse getRunData(int runId) throws PcException, IOException {
        HttpGet getRunDataRequest = new HttpGet(String.format(this.baseURL + "/%s/%s", RUNS_RESOURCE_NAME, runId));
        String runData = this.executeRequest((HttpRequestBase)getRunDataRequest);
        return PcRunResponse.xmlToObject(runData);
    }

    public PcTest getTestData(int testId) throws IOException, PcException {
        HttpGet getTestDataRequest = new HttpGet(String.format(this.baseURL + "/%s/%s", TESTS_RESOURCE_NAME, testId));
        String runData = this.executeRequest((HttpRequestBase)getTestDataRequest);
        return PcTestData.xmlToObject(runData);
    }

    public PcRunResults getRunResults(int runId) throws PcException, ClientProtocolException, IOException {
        String getRunResultsUrl = String.format(this.baseURL + "/%s/%s/%s", RUNS_RESOURCE_NAME, runId, RESULTS_RESOURCE_NAME);
        HttpGet getRunResultsRequest = new HttpGet(getRunResultsUrl);
        String runData = this.executeRequest((HttpRequestBase)getRunResultsRequest);
        return PcRunResults.xmlToObject(runData);
    }

    /*
     * Exception decompiling
     */
    public boolean GetRunResultData(int runId, int resultId, String localFilePath) throws PcException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public TrendReportTransactionDataRoot getTrendReportByXML(String trendReportId, int runId) throws PcException, IOException {
        String url = String.format(this.baseURL + "/%s/%s/%s", TREND_REPORT_RESOURCE_NAME, trendReportId, runId);
        HttpGet request = new HttpGet(url);
        String trendReportByXML = this.executeRequest((HttpRequestBase)request);
        return TrendReportTransactionDataRoot.xmlToObject(trendReportByXML);
    }

    public boolean updateTrendReport(String trendReportId, TrendReportRequest trendReportRequest) throws PcException, IOException {
        String updateTrendReportUrl = String.format(this.baseURL + "/%s/%s", TREND_REPORT_RESOURCE_NAME, trendReportId);
        HttpPost updateTrendReportRequest = new HttpPost(updateTrendReportUrl);
        updateTrendReportRequest.addHeader("Content-Type", CONTENT_TYPE_XML);
        updateTrendReportRequest.setEntity((HttpEntity)new StringEntity(trendReportRequest.objectToXML(), ContentType.APPLICATION_XML));
        this.executeRequest((HttpRequestBase)updateTrendReportRequest);
        return true;
    }

    public InputStream getTrendingPDF(String trendReportId) throws IOException, PcException {
        String getTrendReportUrl = String.format(this.baseURL + "/%s/%s/%s", TREND_REPORT_RESOURCE_NAME, trendReportId, TREND_REPORT_RESOURCE_SUFFIX);
        HttpGet getTrendReportRequest = new HttpGet(getTrendReportUrl);
        final CloseableHttpResponse response = this.executeRawRequest((HttpRequestBase)getTrendReportRequest);
        InputStream rawStream = response.getEntity().getContent();
        return new FilterInputStream(rawStream){

            @Override
            public void close() throws IOException {
                super.close();
                response.close();
            }
        };
    }

    public ArrayList<PcTrendedRun> getTrendReportMetaData(String trendReportId) throws PcException, ClientProtocolException, IOException {
        String getTrendReportMetaDataUrl = String.format(this.baseURL + "/%s/%s", TREND_REPORT_RESOURCE_NAME, trendReportId);
        HttpGet getTrendReportMetaDataRequest = new HttpGet(getTrendReportMetaDataUrl);
        String trendReportMetaData = this.executeRequest((HttpRequestBase)getTrendReportMetaDataRequest);
        return PcTrendReportMetaData.xmlToObject(trendReportMetaData);
    }

    public PcRunEventLog getRunEventLog(int runId) throws PcException, ClientProtocolException, IOException {
        String getRunEventLogUrl = String.format(this.baseURL + "/%s/%s/%s", RUNS_RESOURCE_NAME, runId, EVENTLOG_RESOURCE_NAME);
        HttpGet getRunEventLogRequest = new HttpGet(getRunEventLogUrl);
        String runEventLog = this.executeRequest((HttpRequestBase)getRunEventLogRequest);
        return PcRunEventLog.xmlToObject(runEventLog);
    }

    public Timeslots GetOpenTimeslotsByTestId(int testId) throws PcException, IOException {
        String uri = String.format(this.baseURL + "/%s?%s=%s", TIMESLOTS, "query", URLEncoder.encode("{LoadTestID[" + testId + "]}", "UTF-8"));
        HttpGet getTimeslotsByTestID = new HttpGet(uri);
        String allTimeslots = this.executeRequest((HttpRequestBase)getTimeslotsByTestID);
        Timeslots timeslots = Timeslots.xmlToObject(allTimeslots);
        ArrayList openedTimeslots = timeslots.getTimeslotsList().stream().filter(timeslot -> "open".equalsIgnoreCase(timeslot.getOpenStatus())).collect(Collectors.toCollection(ArrayList::new));
        timeslots.setTimeslotsList(openedTimeslots);
        return timeslots;
    }

    public boolean logout() throws PcException, ClientProtocolException, IOException {
        HttpGet logoutRequest = new HttpGet(String.format(AUTHENTICATION_LOGOUT_URL, this.webProtocol, this.pcServer));
        this.executeRequest((HttpRequestBase)logoutRequest);
        return true;
    }

    protected String executeRequest(HttpRequestBase request) throws PcException, IOException {
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, this.context);){
            if (!PcRestProxy.isOk((HttpResponse)response)) {
                String message;
                try {
                    String content = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    PcErrorResponse exception = PcErrorResponse.xmlToObject(content);
                    message = String.format("%s Error code: %s", exception.getExceptionMessage(), exception.getErrorCode());
                }
                catch (Exception ex) {
                    message = response.getStatusLine().toString();
                }
                throw new PcException("executeRequest exception: " + message);
            }
            String string = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    protected CloseableHttpResponse executeRawRequest(HttpRequestBase request) throws PcException, IOException {
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, this.context);
        if (!PcRestProxy.isOk((HttpResponse)response)) {
            try {
                try {
                    String content = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
                    PcErrorResponse exception = PcErrorResponse.xmlToObject(content);
                    String message = String.format("%s Error code: %s", exception.getExceptionMessage(), exception.getErrorCode());
                    throw new PcException("executeRequest exception: " + message);
                }
                catch (Exception ex) {
                    throw new PcException("executeRequest exception: " + response.getStatusLine());
                }
            }
            catch (Throwable throwable) {
                response.close();
                throw throwable;
            }
        }
        return response;
    }

    public PcScripts getScripts() throws IOException, PcException {
        HttpGet getScriptsRequest = new HttpGet(String.format(this.baseURL + "/%s", SCRIPTS_RESOURCE_NAME));
        String scripts = this.executeRequest((HttpRequestBase)getScriptsRequest);
        return PcScripts.xmlToObject(scripts);
    }

    public PcScript getScript(int Id) throws IOException, PcException {
        HttpGet getScriptsRequest = new HttpGet(String.format(this.baseURL + "/%s/%s", SCRIPTS_RESOURCE_NAME, Id));
        String script = this.executeRequest((HttpRequestBase)getScriptsRequest);
        return PcScript.xmlToObject(script);
    }

    public PcScript getScript(String testFolderPath, String scriptName) throws IOException, PcException {
        ArrayList<PcScript> pcScriptList = this.getScripts().getPcScriptList();
        for (PcScript pcScript : pcScriptList) {
            if (!pcScript.getTestFolderPath().equalsIgnoreCase(testFolderPath) || !pcScript.getName().equalsIgnoreCase(scriptName)) continue;
            return pcScript;
        }
        throw new PcException(String.format("No script named '%s' was found under this folder path '%s' within the PC project.", scriptName, testFolderPath));
    }

    public int uploadScript(String testFolderPath, boolean overwrite, boolean runtimeOnly, boolean keepCheckedOut, String scriptPath) throws PcException, IOException {
        int scriptID;
        this.createTestPlanFolder(testFolderPath);
        HttpPost createScriptRequest = new HttpPost(String.format(this.baseURL + "/%s", SCRIPTS_RESOURCE_NAME));
        File fileToSend = new File(scriptPath);
        ScriptCreateRequest scriptCreateRequest = new ScriptCreateRequest(testFolderPath, overwrite, runtimeOnly, keepCheckedOut);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE).addBinaryBody("File", fileToSend, ContentType.APPLICATION_OCTET_STREAM, fileToSend.getName()).addTextBody("Text", scriptCreateRequest.objectToXML(), ContentType.TEXT_PLAIN);
        createScriptRequest.setEntity(builder.build());
        String responseXml = this.executeRequest((HttpRequestBase)createScriptRequest);
        try {
            scriptID = scriptCreateRequest.getScriptIdFromResponse(responseXml, "ID");
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new PcException("uploadScript exception: " + e, e);
        }
        return scriptID;
    }

    public boolean deleteScript(int scriptId) throws PcException, ClientProtocolException, IOException {
        HttpDelete deleteRequest = new HttpDelete(String.format(this.baseURL + "/%s/%s", SCRIPTS_RESOURCE_NAME, scriptId));
        this.executeRequest((HttpRequestBase)deleteRequest);
        return true;
    }

    public PcTestPlanFolders getTestPlanFolders() throws IOException, PcException {
        HttpGet getFolderTreeRequest = new HttpGet(String.format(this.baseURL + "/%s", TESTPLAN_RESOURCE_NAME));
        String testPlan = this.executeRequest((HttpRequestBase)getFolderTreeRequest);
        return PcTestPlanFolders.xmlToObject(testPlan);
    }

    public boolean verifyTestPlanFolderExist(String path) throws IOException, PcException {
        PcTestPlanFolders pcTestPlanFolders = this.getTestPlanFolders();
        if (pcTestPlanFolders != null) {
            for (PcTestPlanFolder pcTestPlanFolder : pcTestPlanFolders.getPcTestPlanFolderList()) {
                if (!pcTestPlanFolder.getFullPath().equals(path)) continue;
                return true;
            }
        }
        return false;
    }

    public PcTestPlanFolder createTestPlanFolder(String existingPath, String name) throws IOException, PcException {
        HttpPost request = new HttpPost(String.format(this.baseURL + "/%s", TESTPLAN_RESOURCE_NAME));
        TestPlanFolderCreateRequest testPlanFolderCreateRequest = new TestPlanFolderCreateRequest(existingPath, name);
        request.setEntity((HttpEntity)new StringEntity(testPlanFolderCreateRequest.objectToXML(), ContentType.APPLICATION_XML));
        request.addHeader("Content-Type", CONTENT_TYPE_XML);
        String responseXml = this.executeRequest((HttpRequestBase)request);
        try {
            return testPlanFolderCreateRequest.getPcTestPlanFolderFromResponse(responseXml);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new PcException("createTestPlanFolder exception: " + e, e);
        }
    }

    public ArrayList<PcTestPlanFolder> createTestPlanFolders(String[] paths) throws IOException, PcException {
        ArrayList<String[]> pathFromSubjectAndFolders = Helper.getArrayListOfStringArray(paths);
        PcTestPlanFolders pcTestPlanFolders = this.getTestPlanFolders();
        ArrayList<String[]> pathFromSubjectAndFoldersFiltered = Helper.getCleanAndNonExistingAndSortedArrayList(pathFromSubjectAndFolders, pcTestPlanFolders);
        return this.createPcTestPlanFolders(pathFromSubjectAndFoldersFiltered);
    }

    public ArrayList<PcTestPlanFolder> createPcTestPlanFolders(ArrayList<String[]> stringsOfExistingPathFromSubjectAndOfFolderToCreate) throws IOException, PcException {
        ArrayList<PcTestPlanFolder> createdPcTestPlanFolders = new ArrayList<PcTestPlanFolder>();
        if (!stringsOfExistingPathFromSubjectAndOfFolderToCreate.isEmpty()) {
            for (String[] pathFromSubjectAndFolder : stringsOfExistingPathFromSubjectAndOfFolderToCreate) {
                PcTestPlanFolder createdPcTestPlanFolder = this.createTestPlanFolder(pathFromSubjectAndFolder[0], pathFromSubjectAndFolder[1]);
                createdPcTestPlanFolders.add(createdPcTestPlanFolder);
            }
        }
        return createdPcTestPlanFolders;
    }

    public Test createOrUpdateTestFromYamlTest(String testString) throws IOException, PcException {
        SimplifiedTest simplifiedTest = PcRestProxy.xmlOrYamlStringToSimplifiedTest(testString);
        return this.createOrUpdateTestFromYamlContent("", "", testString);
    }

    public Test createOrUpdateTestFromYamlContent(String testName, String testFolderPath, String testOrContent) throws IOException, PcException {
        Test createdOrUpdatedTest = null;
        ConvertContentStringToTest convertContentStringToTest = new ConvertContentStringToTest(this, testName, testFolderPath, testOrContent).invoke();
        createdOrUpdatedTest = this.createOrUpdateTest(convertContentStringToTest.getTestName(), convertContentStringToTest.getTestFolderPathWithSubject(), convertContentStringToTest.getContent());
        return createdOrUpdatedTest;
    }

    public Test createOrUpdateTest(String testName, String testFolderPath, String xml) throws IOException, PcException {
        String testFolderPathWithCorrectSeparatorsAndSubject = testFolderPath.replace("/", "\\");
        if (!testFolderPath.startsWith("Subject")) {
            testFolderPathWithCorrectSeparatorsAndSubject = "Subject\\".concat(testFolderPath);
        }
        Content content = PcRestProxy.getContentFromXmlOrYamlString(xml);
        return this.createOrUpdateTest(testName, testFolderPathWithCorrectSeparatorsAndSubject, content);
    }

    public Test createOrUpdateTest(String testName, String testFolderPath, Content content) throws IOException, PcException {
        this.createTestPlanFolder(testFolderPath);
        try {
            HttpPost createTestRequest = new HttpPost(String.format(this.baseURL + "/%s", TESTS_RESOURCE_NAME));
            Test test = new Test(testName, testFolderPath, content);
            createTestRequest.setEntity((HttpEntity)new StringEntity(test.objectToXML(), ContentType.APPLICATION_XML));
            String createTestResponse = this.executeRequest((HttpRequestBase)createTestRequest);
            return Test.xmlToObject(createTestResponse);
        }
        catch (PcException e) {
            int testId = this.extractTestIdFromString(e.getMessage());
            if (testId != 0) {
                return this.updateTest(testId, content);
            }
            throw e;
        }
    }

    private void createTestPlanFolder(String testFolderPath) {
        try {
            if (!this.verifyTestPlanFolderExist(testFolderPath)) {
                String[] scriptPathArray = new String[]{testFolderPath};
                this.createTestPlanFolders(scriptPathArray);
            }
        }
        catch (PcException | IOException exception) {
            // empty catch block
        }
    }

    public Test getTest(int testId) throws IOException, PcException {
        HttpGet getTestRequest = new HttpGet(String.format(this.baseURL + "/%s/%s", TESTS_RESOURCE_NAME, testId));
        String xmlTest = this.executeRequest((HttpRequestBase)getTestRequest);
        return Test.xmlToObject(xmlTest);
    }

    public Test updateTest(int testId, Content content) throws IOException, PcException {
        HttpPut updateTestRequest = new HttpPut(String.format(this.baseURL + "/%s/%s", TESTS_RESOURCE_NAME, testId));
        updateTestRequest.setEntity((HttpEntity)new StringEntity(content.objectToXML(true), ContentType.APPLICATION_XML));
        this.executeRequest((HttpRequestBase)updateTestRequest);
        return this.getTest(testId);
    }

    public boolean deleteTest(int testId) throws IOException, PcException {
        HttpDelete deleteTestRequest = new HttpDelete(String.format(this.baseURL + "/%s/%s", TESTS_RESOURCE_NAME, testId));
        this.executeRequest((HttpRequestBase)deleteTestRequest);
        return true;
    }

    protected String getBaseURL() {
        return this.baseURL;
    }

    public int extractTestIdFromString(String value) {
        return Helper.extractTestIdFromString(value);
    }

    public Content readYaml(String yamlContent) throws IOException {
        Content content = null;
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            Test test = (Test)mapper.readValue(yamlContent, Test.class);
            content = test.getContent();
        }
        catch (IOException ex) {
            content = (Content)mapper.readValue(yamlContent, Content.class);
        }
        return content;
    }

    public String GetPcServer() {
        return this.pcServer;
    }

    public String GetTenant() {
        return this.tenantSuffix;
    }
}

