/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.util;

import java.util.Collection;

public class StringUtils {
    public static String removeSuffix(String str, String suffix) {
        int pos = str.lastIndexOf(suffix);
        return str.substring(0, pos);
    }

    public static String joinWithDelim(String delim, Object ... objs) {
        StringBuilder sb = new StringBuilder();
        for (Object o : objs) {
            if (sb.length() > 0) {
                sb.append(delim);
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }

    public static String createTable(Collection<? extends Collection<String>> data) {
        return StringUtils.createTable(data, null);
    }

    public static String createTable(Collection<? extends Collection<String>> data, Collection<String> headers) {
        if (data.isEmpty()) {
            throw new IllegalArgumentException("There are no data for table creation.");
        }
        String format = StringUtils.countTableStringFormat(data, headers == null ? data.iterator().next() : headers);
        StringBuilder sb = new StringBuilder();
        if (headers != null) {
            sb.append(String.format(format, headers.toArray()));
        }
        for (Collection<String> collection : data) {
            sb.append(String.format(format, collection.toArray()));
        }
        return sb.toString();
    }

    private static String countTableStringFormat(Collection<? extends Collection<String>> data, Collection<String> headers) {
        int cols = headers.size();
        int[] colSizes = new int[cols];
        int i = 0;
        for (String string : headers) {
            colSizes[i] = string.length() + 2;
            ++i;
        }
        for (Collection collection : data) {
            if (collection.size() != cols) {
                throw new IllegalArgumentException("data row has different column count!");
            }
            i = 0;
            for (Object cell : collection) {
                String s = cell.toString();
                int len = s.length() + 2;
                if (colSizes[i] < len) {
                    colSizes[i] = len;
                }
                ++i;
            }
        }
        String format = "";
        for (int size : colSizes) {
            format = format + "%-" + size + "s ";
        }
        return format + "\n";
    }
}

