/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.util;

import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import com.microfocus.sv.svconfigurator.serverclient.IServerManagementEndpointClient;
import com.microfocus.sv.svconfigurator.serverclient.impl.RestClient;
import com.microfocus.sv.svconfigurator.serverclient.impl.ServerManagementEndpointClient;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.DefaultHttpClient;

public class HttpUtils {
    public static IServerManagementEndpointClient createServerManagementEndpointClient(URL mgmtUri, boolean trustEveryone, Credentials credentials) throws CommunicatorException {
        HttpClient httpClient = trustEveryone ? HttpUtils.trustEveryoneSslHttpClient() : new DefaultHttpClient();
        RestClient restClient = new RestClient(credentials, httpClient);
        return new ServerManagementEndpointClient(mgmtUri, restClient);
    }

    public static HttpClient trustEveryoneSslHttpClient() {
        try {
            SSLSocketFactory socketFactory = new SSLSocketFactory(new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            DefaultHttpClient client = new DefaultHttpClient();
            client.getConnectionManager().getSchemeRegistry().register(new Scheme("https", 443, (SchemeSocketFactory)socketFactory));
            return client;
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

