/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.service;

import com.microfocus.sv.svconfigurator.core.impl.jaxb.AgentConfiguration;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.AgentConfigurations;
import com.microfocus.sv.svconfigurator.service.ServiceAgentUpdater;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class ServiceAgentUpdaterBase
implements ServiceAgentUpdater {
    protected Map<String, List<AgentConfiguration>> agentConfigurationsByType = new HashMap<String, List<AgentConfiguration>>();
    protected Map<String, AgentConfiguration> agentConfigurationsById = new HashMap<String, AgentConfiguration>();
    protected Map<String, AgentConfiguration> agentConfigurationsByName = new HashMap<String, AgentConfiguration>();

    public ServiceAgentUpdaterBase(AgentConfigurations agentConfigurations) {
        for (AgentConfiguration agentConfiguration : agentConfigurations.getConfigurations()) {
            if (!this.agentConfigurationsByType.containsKey(agentConfiguration.getType())) {
                ArrayList<AgentConfiguration> initialList = new ArrayList<AgentConfiguration>();
                initialList.add(agentConfiguration);
                this.agentConfigurationsByType.put(agentConfiguration.getType(), initialList);
            } else {
                this.agentConfigurationsByType.get(agentConfiguration.getType()).add(agentConfiguration);
            }
            this.agentConfigurationsById.put(agentConfiguration.getAgentId(), agentConfiguration);
            this.agentConfigurationsByName.put(agentConfiguration.getName(), agentConfiguration);
        }
    }

    @Override
    public String getServerAgentName(String desiredAgentType, String id) {
        AgentConfiguration agentConfiguration = this.agentConfigurationsById.get(id);
        if (agentConfiguration != null && agentConfiguration.getType().equals(desiredAgentType)) {
            return agentConfiguration.getName();
        }
        return null;
    }
}

