/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.processor.utils;

import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.util.XmlUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ServiceAgentsInfo {
    String agentType;
    Map<String, AgentRef> agentRefs = new HashMap<String, AgentRef>();
    boolean modified;
    public static final String ATTR_NAME = "name";
    public static final String ATTR_REF = "ref";

    public ServiceAgentsInfo(IService service) throws IOException, SVCParseException {
        Document doc = XmlUtils.createDoc(service.getData());
        doc.getDocumentElement().normalize();
        Node virtualEndpoint = doc.getElementsByTagNameNS("http://hp.com/SOAQ/ServiceVirtualization/2010/", "virtualEndpoint").item(0);
        this.agentType = virtualEndpoint.getAttributes().getNamedItem("type").getNodeValue();
        for (String nodeName : Arrays.asList("virtualInputAgent", "virtualOutputAgent", "realInputAgent", "realOutputAgent")) {
            NamedNodeMap agentAttributes = doc.getElementsByTagNameNS("http://hp.com/SOAQ/ServiceVirtualization/2010/", nodeName).item(0).getAttributes();
            Node idAttr = agentAttributes.getNamedItem(ATTR_REF);
            String id = idAttr.getNodeValue();
            Node nameAttr = agentAttributes.getNamedItem(ATTR_NAME);
            String name = nameAttr != null ? nameAttr.getNodeValue() : null;
            this.agentRefs.put(nodeName, new AgentRef(id, name));
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public String getAgentType() {
        return this.agentType;
    }

    public Map<String, AgentRef> getAgentRefs() {
        return this.agentRefs;
    }

    public class AgentRef {
        String id;
        String name;

        public AgentRef(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setId(String id) {
            this.setModified(this.id, id);
            this.id = id;
        }

        public void setName(String name) {
            this.setModified(this.name, name);
            this.name = name;
        }

        private void setModified(String oldValue, String newValue) {
            if (oldValue == null ? newValue != null : !oldValue.equals(newValue)) {
                ServiceAgentsInfo.this.modified = true;
            }
        }
    }
}

