/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.processor.printer;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.Service;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeConfiguration;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeReport;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.atom.ServiceListAtom;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.helper.ReferenceElement;
import com.microfocus.sv.svconfigurator.processor.printer.IPrinter;
import com.microfocus.sv.svconfigurator.processor.printer.NonPrintable;
import java.lang.reflect.Type;
import java.util.Map;

public class JsonPrinter
implements IPrinter {
    private Gson serializersGson;
    private Gson gson;

    private JsonObject beginServiceSerialization(Object serviceObj, boolean nonExistentRealService) {
        JsonObject js = this.serializersGson.toJsonTree(serviceObj).getAsJsonObject();
        js.addProperty("useRealService", Boolean.valueOf(!nonExistentRealService));
        return js;
    }

    public JsonPrinter() {
        GsonBuilder builder = new GsonBuilder().setPrettyPrinting().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").registerTypeAdapter(ReferenceElement.class, (Object)new ReferenceElementSerializer()).addSerializationExclusionStrategy(new ExclusionStrategy(){

            public boolean shouldSkipField(FieldAttributes f) {
                return f.getAnnotation(NonPrintable.class) != null;
            }

            public boolean shouldSkipClass(Class<?> clazz) {
                return false;
            }
        });
        this.serializersGson = builder.create();
        builder.registerTypeAdapter(ServiceListAtom.ServiceEntry.class, (Object)new ServiceEntrySerializer());
        builder.registerTypeAdapter(Service.class, (Object)new ServiceSerializer());
        this.gson = builder.create();
    }

    @Override
    public String createServiceInfoOutput(IService svc, ServiceRuntimeConfiguration conf, ServiceRuntimeReport report) {
        return this.gson.toJson((Object)new ViewServiceDetails(svc, conf, report));
    }

    @Override
    public String createServiceListOutput(ServiceListAtom atom) {
        return this.gson.toJson(atom.getEntries());
    }

    @Override
    public String createProjectListOutput(IProject project) {
        return this.gson.toJson((Object)project);
    }

    private static class ViewServiceDetails {
        IService service;
        ServiceRuntimeConfiguration runtimeConfiguration;
        ServiceRuntimeReport runtimeReport;

        public ViewServiceDetails(IService service, ServiceRuntimeConfiguration runtimeConfiguration, ServiceRuntimeReport runtimeReport) {
            this.service = service;
            this.runtimeConfiguration = runtimeConfiguration;
            this.runtimeReport = runtimeReport;
        }
    }

    private class ServiceSerializer
    implements JsonSerializer<Service> {
        private ServiceSerializer() {
        }

        public JsonElement serialize(Service src, Type typeOfSrc, JsonSerializationContext context) {
            return JsonPrinter.this.beginServiceSerialization(src, src.NonExistentRealService());
        }
    }

    private class ServiceEntrySerializer
    implements JsonSerializer<ServiceListAtom.ServiceEntry> {
        private ServiceEntrySerializer() {
        }

        public JsonElement serialize(ServiceListAtom.ServiceEntry src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject js = JsonPrinter.this.beginServiceSerialization(src, Boolean.parseBoolean(src.getNonExistentRealService()));
            Map runtimeIssuesMap = (Map)JsonPrinter.this.gson.fromJson(src.getRuntimeIssues(), Map.class);
            Object issues = runtimeIssuesMap.get("issues");
            if (issues != null) {
                js.add("runtimeIssues", JsonPrinter.this.gson.toJsonTree(issues));
            }
            return js;
        }
    }

    private static class ReferenceElementSerializer
    implements JsonSerializer<ReferenceElement> {
        private ReferenceElementSerializer() {
        }

        public JsonElement serialize(ReferenceElement src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.getRef());
        }
    }
}

