/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.processor;

import com.microfocus.sv.svconfigurator.Global;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.processor.IUnlockProcessor;
import com.microfocus.sv.svconfigurator.processor.UnlockProcessorInput;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutorFactory;

public class UnlockProcessor
implements IUnlockProcessor {
    private ICommandExecutorFactory commandExecutorFactory;

    public UnlockProcessor(ICommandExecutorFactory commandExecutorFactory) {
        this.commandExecutorFactory = commandExecutorFactory;
    }

    @Override
    public ICommandExecutorFactory getCommandExecutorFactory() {
        return this.commandExecutorFactory;
    }

    @Override
    public void process(UnlockProcessorInput input, ICommandExecutor exec) throws CommunicatorException, CommandExecutorException {
        String svcStr = input.getService();
        if (svcStr == null) {
            throw new CommandExecutorException("Service have to be specified");
        }
        IService svc = exec.findService(svcStr, input.getProject());
        String clientId = input.isLock() ? Global.getClientId(exec) : null;
        exec.lockService(svc, clientId);
    }
}

