/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.processor;

import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.atom.ServiceListAtom;
import com.microfocus.sv.svconfigurator.processor.IListProcessor;
import com.microfocus.sv.svconfigurator.processor.printer.IPrinter;
import com.microfocus.sv.svconfigurator.processor.printer.PrinterFactory;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListProcessor
implements IListProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ListProcessor.class);
    private ICommandExecutorFactory commandExecutorFactory;

    public ListProcessor(ICommandExecutorFactory commandExecutorFactory) {
        this.commandExecutorFactory = commandExecutorFactory;
    }

    @Override
    public ICommandExecutorFactory getCommandExecutorFactory() {
        return this.commandExecutorFactory;
    }

    @Override
    public void process(IProject proj, String outputFormat, ICommandExecutor exec) throws CommunicatorException {
        ServiceListAtom atom = exec.getServiceList(proj == null ? null : proj.getId());
        IPrinter printer = PrinterFactory.create(outputFormat);
        LOG.info(printer.createServiceListOutput(atom));
    }
}

