/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.processor;

import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.AgentConfigurations;
import com.microfocus.sv.svconfigurator.processor.DeployProcessorInput;
import com.microfocus.sv.svconfigurator.processor.IDeployProcessor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutorFactory;
import com.microfocus.sv.svconfigurator.service.ServiceAmendingServiceImpl;
import com.microfocus.sv.svconfigurator.util.ProjectUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeployProcessor
implements IDeployProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(DeployProcessor.class);
    private final ICommandExecutorFactory commandExecutorFactory;

    public DeployProcessor(ICommandExecutorFactory commandExecutorFactory) {
        this.commandExecutorFactory = commandExecutorFactory;
    }

    @Override
    public ICommandExecutorFactory getCommandExecutorFactory() {
        return this.commandExecutorFactory;
    }

    @Override
    public void process(DeployProcessorInput input, ICommandExecutor exec) throws CommunicatorException, CommandExecutorException {
        IProject proj = input.getProject();
        if (proj == null) {
            throw new CommandExecutorException("You have to specify the project.");
        }
        exec.setForce(input.isForce());
        IService svc = ProjectUtils.findProjElem(proj.getServices(), input.getService(), "Virtual service");
        if (input.isUndeploy()) {
            this.undeploy(proj, exec, svc);
        } else {
            this.deploy(proj, exec, svc, input);
        }
    }

    private void deploy(IProject proj, ICommandExecutor exec, IService service, DeployProcessorInput input) throws CommunicatorException, CommandExecutorException {
        ArrayList<IService> services = new ArrayList<IService>();
        if (service == null) {
            for (IService svc : proj.getServices()) {
                services.add(svc);
            }
        } else {
            services.add(service);
        }
        List<IService> updatedServices = this.updateAndValidateServiceAgents(exec, input, services);
        for (IService svc : updatedServices) {
            exec.deployService(svc, proj.getProjectPassword(), input.isImportLoggedMessages());
        }
        if (service == null) {
            LOG.info(proj + " successfully deployed.");
        }
    }

    private List<IService> updateAndValidateServiceAgents(ICommandExecutor exec, DeployProcessorInput input, List<IService> services) throws CommunicatorException, CommandExecutorException {
        AgentConfigurations agentConfigurations = exec.getAgents();
        ServiceAmendingServiceImpl serviceAmendingService = new ServiceAmendingServiceImpl(agentConfigurations, services);
        if (input.isAgentRemappingRequired()) {
            serviceAmendingService.remapAgents(input.getAgentRemapping());
        }
        serviceAmendingService.remapAgentsByNames();
        if (input.isFirstAgentFailover()) {
            serviceAmendingService.agentFallback();
        }
        serviceAmendingService.verifyAndSetNames();
        return serviceAmendingService.applyAgentChanges();
    }

    private void undeploy(IProject proj, ICommandExecutor exec, IService svc) throws CommunicatorException, CommandExecutorException {
        if (svc == null) {
            exec.undeploy(proj);
        } else {
            exec.undeployService(svc);
        }
    }
}

