/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.processor;

import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeConfiguration;

public class ChmodeProcessorInput {
    private boolean force;
    private IProject project;
    private String service;
    private String dataModel;
    private String perfModel;
    private ServiceRuntimeConfiguration.RuntimeMode serviceMode;
    private ServiceRuntimeConfiguration.RuntimeMode desiredServiceMode;
    private boolean defaultDataModel;
    private boolean defaultPerfModel;

    public ChmodeProcessorInput(boolean force, IProject project, String service, String dataModel, String perfModel, ServiceRuntimeConfiguration.RuntimeMode serviceMode, boolean defaultDataModel, boolean defaultPerfModel) {
        this.force = force;
        this.project = project;
        this.service = service;
        this.dataModel = dataModel;
        this.perfModel = perfModel;
        this.desiredServiceMode = serviceMode;
        this.serviceMode = ChmodeProcessorInput.getTargetMode(serviceMode, perfModel, dataModel, defaultDataModel, defaultPerfModel);
        this.defaultDataModel = defaultDataModel;
        this.defaultPerfModel = defaultPerfModel;
    }

    private static ServiceRuntimeConfiguration.RuntimeMode getTargetMode(ServiceRuntimeConfiguration.RuntimeMode serviceMode, String perfModel, String dataModel, boolean defaultDataModel, boolean defaultPerfModel) {
        if (serviceMode == ServiceRuntimeConfiguration.RuntimeMode.SIMULATING && dataModel == null && !defaultDataModel && (perfModel != null || defaultPerfModel)) {
            return ServiceRuntimeConfiguration.RuntimeMode.STAND_BY;
        }
        return serviceMode;
    }

    public boolean isForce() {
        return this.force;
    }

    public IProject getProject() {
        return this.project;
    }

    public String getService() {
        return this.service;
    }

    public String getDataModel() {
        return this.dataModel;
    }

    public String getPerfModel() {
        return this.perfModel;
    }

    public ServiceRuntimeConfiguration.RuntimeMode getServiceMode() {
        return this.serviceMode;
    }

    public boolean isDefaultDataModel() {
        return this.defaultDataModel;
    }

    public boolean isDefaultPerfModel() {
        return this.defaultPerfModel;
    }

    public ServiceRuntimeConfiguration.RuntimeMode getDesiredServiceMode() {
        return this.desiredServiceMode;
    }
}

