/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.processor;

import com.microfocus.sv.svconfigurator.core.IDataModel;
import com.microfocus.sv.svconfigurator.core.IPerfModel;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.ServiceRuntimeConfiguration;
import com.microfocus.sv.svconfigurator.processor.ChmodeProcessorInput;
import com.microfocus.sv.svconfigurator.processor.IChmodeProcessor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutorFactory;
import com.microfocus.sv.svconfigurator.util.ProjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChmodeProcessor
implements IChmodeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ChmodeProcessor.class);
    private ICommandExecutorFactory commandExecutorFactory;

    public ChmodeProcessor(ICommandExecutorFactory commandExecutorFactory) {
        this.commandExecutorFactory = commandExecutorFactory;
    }

    @Override
    public ICommandExecutorFactory getCommandExecutorFactory() {
        return this.commandExecutorFactory;
    }

    @Override
    public void process(ChmodeProcessorInput input, ICommandExecutor exec) throws CommandExecutorException, SVCParseException, CommunicatorException {
        exec.setForce(input.isForce());
        IProject proj = input.getProject();
        IService svc = proj == null ? exec.findService(input.getService(), null) : ProjectUtils.findProjElem(proj.getServices(), input.getService(), "Virtual service");
        ServiceRuntimeConfiguration conf = new ServiceRuntimeConfiguration(svc, input.getServiceMode(), false, ServiceRuntimeConfiguration.DeploymentState.READY);
        String dataModel = input.getDataModel();
        String perfModel = input.getPerfModel();
        if (svc.NonExistentRealService() && (input.getServiceMode() == ServiceRuntimeConfiguration.RuntimeMode.STAND_BY || input.getServiceMode() == ServiceRuntimeConfiguration.RuntimeMode.LEARNING)) {
            throw new CommandExecutorException("Virtual service without real service configuration cannot be switchted to " + input.getServiceMode().toString() + " mode.");
        }
        if (dataModel != null) {
            String dataModelId = ProjectUtils.findProjElem(svc.getDataModels(), dataModel, "Data model").getId();
            conf.setDataModelId(dataModelId);
        }
        if (perfModel != null) {
            IPerfModel model = ProjectUtils.findProjElem(svc.getPerfModels(), perfModel, "Data model");
            if (model.isOffline() && input.getServiceMode() == ServiceRuntimeConfiguration.RuntimeMode.LEARNING) {
                throw new CommandExecutorException("Offline performance model cannot be selected in the LEARNING mode.");
            }
            conf.setPerfModelId(model.getId());
        }
        if (dataModel == null && input.isDefaultDataModel() && (input.getServiceMode() == ServiceRuntimeConfiguration.RuntimeMode.SIMULATING || input.getServiceMode() == ServiceRuntimeConfiguration.RuntimeMode.LEARNING)) {
            this.setDefaultDataModel(svc, conf);
        }
        if (perfModel == null && input.isDefaultPerfModel() && (input.getServiceMode() == ServiceRuntimeConfiguration.RuntimeMode.SIMULATING || input.getServiceMode() == ServiceRuntimeConfiguration.RuntimeMode.STAND_BY || input.getServiceMode() == ServiceRuntimeConfiguration.RuntimeMode.LEARNING)) {
            this.setDefaultPerfModel(svc, conf);
        }
        if (conf.getDisplayRuntimeMode() != input.getDesiredServiceMode()) {
            LOG.warn("Target service mode " + (Object)((Object)input.getDesiredServiceMode()) + " has been translated to " + (Object)((Object)conf.getDisplayRuntimeMode()) + " to be in accord with Service Virtualization Designer. Feel free to use " + (Object)((Object)conf.getDisplayRuntimeMode()) + " mode directly.");
        }
        exec.setServiceRuntime(svc, conf);
    }

    private void setDefaultDataModel(IService svc, ServiceRuntimeConfiguration conf) {
        ArrayList<IDataModel> dms = new ArrayList<IDataModel>(svc.getDataModels());
        if (!dms.isEmpty()) {
            Collections.sort(dms);
            String dataModelId = ((IDataModel)dms.get(0)).getId();
            conf.setDataModelId(dataModelId);
        }
    }

    private void setDefaultPerfModel(IService svc, ServiceRuntimeConfiguration conf) {
        ArrayList<IPerfModel> pms = new ArrayList<IPerfModel>(svc.getPerfModels());
        if (!pms.isEmpty()) {
            Collections.sort(pms);
            for (IPerfModel pm : pms) {
                if (pm.isOffline()) continue;
                conf.setPerfModelId(pm.getId());
                break;
            }
        }
    }
}

