/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.core.impl.datasource;

import com.microfocus.sv.svconfigurator.core.IProjectElementDataSource;
import java.io.IOException;
import java.io.InputStream;
import net.lingala.zip4j.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.FileHeader;

public class ArchiveProjectElementDataSource
implements IProjectElementDataSource {
    private ZipFile zipFile;
    private FileHeader fileHeader;

    public ArchiveProjectElementDataSource(ZipFile zipFile, FileHeader fileHeader) {
        this.zipFile = zipFile;
        this.fileHeader = fileHeader;
    }

    @Override
    public long getDataSize() {
        return this.fileHeader.getUncompressedSize();
    }

    @Override
    public InputStream getData() throws IOException {
        try {
            return this.zipFile.getInputStream(this.fileHeader);
        }
        catch (ZipException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    @Override
    public String getName() {
        return this.fileHeader.getFileName();
    }

    @Override
    public void close() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArchiveProjectElementDataSource)) {
            return false;
        }
        ArchiveProjectElementDataSource that = (ArchiveProjectElementDataSource)o;
        if (this.fileHeader != null ? !this.fileHeader.equals((Object)that.fileHeader) : that.fileHeader != null) {
            return false;
        }
        return !(this.zipFile == null ? that.zipFile != null : !this.zipFile.equals(that.zipFile));
    }

    public int hashCode() {
        int result = this.zipFile != null ? this.zipFile.hashCode() : 0;
        result = 31 * result + (this.fileHeader != null ? this.fileHeader.hashCode() : 0);
        return result;
    }
}

