/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.core;

import com.microfocus.sv.svconfigurator.core.IProjectElement;
import com.microfocus.sv.svconfigurator.core.IProjectElementDataSource;
import com.microfocus.sv.svconfigurator.core.encryption.EncryptionMetadata;
import com.microfocus.sv.svconfigurator.core.impl.encryption.ProjectElementDecryptorImpl;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.processor.printer.NonPrintable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractProjectElement
implements IProjectElement {
    private final ProjectElementDecryptorImpl decryptor;
    protected EncryptionMetadata encryptionMetadata;
    private String id;
    private String name;
    @NonPrintable
    protected String projectPassword;
    @NonPrintable
    private IProjectElementDataSource ds;
    private byte[] decryptedBytes = null;

    public AbstractProjectElement(String id, String name, IProjectElementDataSource ds) {
        this(id, name, ds, null, null);
    }

    public AbstractProjectElement(String id, String name, IProjectElementDataSource ds, EncryptionMetadata encryptionMetadata, String projectPassword) {
        this.id = id;
        this.name = name;
        this.ds = ds;
        this.encryptionMetadata = encryptionMetadata;
        this.projectPassword = projectPassword;
        this.decryptor = encryptionMetadata != null && encryptionMetadata.hasEncryptedNodes() ? new ProjectElementDecryptorImpl(encryptionMetadata) : null;
    }

    @Override
    public void close() throws IOException {
        this.ds.close();
    }

    @Override
    public InputStream getData() throws IOException, SVCParseException {
        InputStream retVal = this.encryptionMetadata == null || !this.encryptionMetadata.hasEncryptedNodes() ? this.ds.getData() : this.decodeData(this.projectPassword, this.ds.getData());
        return retVal;
    }

    private InputStream decodeData(String projectPassword, InputStream data) throws SVCParseException {
        if (this.decryptor != null) {
            return new ByteArrayInputStream(this.getDecryptedBytes(projectPassword, data));
        }
        return data;
    }

    private byte[] getDecryptedBytes(String projectPassword, InputStream data) throws SVCParseException {
        if (this.decryptedBytes == null) {
            this.decryptedBytes = this.decryptor.decodeStream(data, projectPassword);
        }
        return this.decryptedBytes;
    }

    @Override
    public long getDataLength() throws IOException, SVCParseException {
        if (this.decryptor != null) {
            return this.getDecryptedBytes(this.projectPassword, this.ds.getData()).length;
        }
        return this.ds.getDataSize();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }
}

