/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.cli.impl;

import com.microfocus.sv.svconfigurator.build.IProjectBuilder;
import com.microfocus.sv.svconfigurator.cli.impl.AbstractProjectCommandProcessor;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.impl.Server;
import com.microfocus.sv.svconfigurator.core.impl.exception.AbstractSVCException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommandExecutorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.exception.ProjectBuilderException;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.core.server.IServerCommandRunner;
import com.microfocus.sv.svconfigurator.core.server.ServersCommandExecutor;
import com.microfocus.sv.svconfigurator.processor.IViewProcessor;
import com.microfocus.sv.svconfigurator.processor.ViewProcessorInput;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.util.CliUtils;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewCLICommandProcessor
extends AbstractProjectCommandProcessor {
    public static final String COMMAND = "view";
    private static final Logger LOG = LoggerFactory.getLogger(ViewCLICommandProcessor.class);
    private static final String PROPERTY_REPORT = "r";
    private static final String LONG_PROPERTY_REPORT = "report";
    private static final String PARAM_SERVICE = "service";
    private static final String HELP_USAGE = "view [parameters] <service>";
    private IViewProcessor proc;
    private Options opts;

    public ViewCLICommandProcessor(IProjectBuilder projectBuilder, IViewProcessor proc) {
        super(projectBuilder);
        this.proc = proc;
        this.opts = this.createPropertyOptions();
    }

    @Override
    public int process(String[] args) {
        BasicParser parser = new BasicParser();
        try {
            CommandLine line = parser.parse(this.opts, args);
            String[] lineArgs = line.getArgs();
            if (lineArgs.length != 1) {
                throw new ParseException("Bad arguments count, please take a look into the help.");
            }
            IProject proj = null;
            if (line.hasOption("p")) {
                String projPass = line.hasOption("w") ? line.getOptionValue("w") : null;
                proj = this.getProject(line.getOptionValue("p"), projPass);
            }
            List<Server> servers = CliUtils.obtainServers(line, null, true);
            String outputFormat = CliUtils.obtainOutputFormat(line);
            final ViewProcessorInput input = new ViewProcessorInput(line.hasOption(PROPERTY_REPORT), proj, lineArgs[0], outputFormat);
            ServersCommandExecutor executor = new ServersCommandExecutor(servers, this.proc.getCommandExecutorFactory());
            executor.execute(new IServerCommandRunner(){

                @Override
                public void runCommand(ICommandExecutor executor) throws AbstractSVCException {
                    ViewCLICommandProcessor.this.proc.process(input, executor);
                }
            });
        }
        catch (ParseException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            this.printHelp();
            return 1000;
        }
        catch (SVCParseException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            this.printHelp();
            return 1000;
        }
        catch (ProjectBuilderException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return 1100;
        }
        catch (CommunicatorException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return 1200;
        }
        catch (CommandExecutorException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return 1300;
        }
        catch (IllegalArgumentException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return 1000;
        }
        catch (AbstractSVCException e) {
            LOG.error(e.getLocalizedMessage(), (Throwable)e);
            return 1500;
        }
        return 0;
    }

    private Options createPropertyOptions() {
        Options opts = new Options();
        CliUtils.addConnectionOptions(opts);
        opts.addOption(PROPERTY_REPORT, LONG_PROPERTY_REPORT, false, "Prints the service runtime report.");
        opts.addOption("p", "project", true, "Processes the project file (.vproja or .vproj). You have to specify the project file either if you want to identify the service by its name or if you want to obtain the server management URL from the project.");
        opts.addOption("w", "project-password", true, "Project encryption password");
        CliUtils.addOutputFormatOptions(opts);
        return opts;
    }

    private Options createMandatParamsOptions() {
        Options opts = new Options();
        opts.addOption(PARAM_SERVICE, false, "Service identification (ID or name). There can be more services with the same name in the server. In this case you will be asked either to use the ID of the service or specify the project where the service is. Unfortunately there can also be more services with the same name in the project and if they are, you have to use the service ID.");
        return opts;
    }

    private void printHelp() {
        CliUtils.printHelp(HELP_USAGE, this.opts, this.createMandatParamsOptions());
    }
}

