/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.cli.impl;

import com.microfocus.sv.svconfigurator.cli.impl.base.CliServerCommandProcessorBase;
import com.microfocus.sv.svconfigurator.core.IService;
import com.microfocus.sv.svconfigurator.core.impl.exception.AbstractSVCException;
import com.microfocus.sv.svconfigurator.serverclient.ICommandExecutor;
import com.microfocus.sv.svconfigurator.util.StringUtils;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;

public class SetLoggingCliCommandProcessor
extends CliServerCommandProcessorBase {
    public static final String COMMAND = "setLogging";
    public static final String ENABLED_ARG = "enabled";
    public static final String DISABLED_ARG = "disabled";
    public static final String SERVICE_ARG = "service_ident";
    public static final String LOGGING_ARG = "logging_value";
    String serviceIdentArg;
    boolean enableLoggingArg;

    public SetLoggingCliCommandProcessor() {
        super(COMMAND);
    }

    @Override
    protected boolean initParameters(CommandLine parameters) {
        String[] args = parameters.getArgs();
        if (args.length != 2) {
            return false;
        }
        this.serviceIdentArg = args[0];
        if (ENABLED_ARG.equals(args[1])) {
            this.enableLoggingArg = true;
        } else if (DISABLED_ARG.equals(args[1])) {
            this.enableLoggingArg = false;
        } else {
            return false;
        }
        return true;
    }

    @Override
    protected int executeWithServerExecutor(CommandLine parameters, ICommandExecutor executor) throws AbstractSVCException {
        IService service = executor.findService(this.serviceIdentArg, null);
        executor.changeVirtualServiceLoggingConfiguration(service, this.enableLoggingArg);
        return 0;
    }

    @Override
    public String getHelpUsage() {
        return this.command + " [parameters] <" + SERVICE_ARG + "> <" + LOGGING_ARG + ">";
    }

    @Override
    protected void addMandatoryCommandLineOptions(Options options) {
        options.addOption(SERVICE_ARG, false, "Identification of the service (ID or the name).");
        options.addOption(LOGGING_ARG, false, "Logging setting. Value have to be one of these values: " + StringUtils.joinWithDelim(", ", ENABLED_ARG, DISABLED_ARG) + ".");
    }
}

