/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.cli.impl;

import com.microfocus.sv.svconfigurator.build.IProjectBuilder;
import com.microfocus.sv.svconfigurator.cli.ICLICommandProcessor;
import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.impl.exception.ProjectBuilderException;
import java.io.File;
import org.apache.commons.cli.CommandLine;

public abstract class AbstractProjectCommandProcessor
implements ICLICommandProcessor {
    private final IProjectBuilder projectBuilder;

    public AbstractProjectCommandProcessor(IProjectBuilder projectBuilder) {
        this.projectBuilder = projectBuilder;
    }

    protected IProject getProject(CommandLine line) throws ProjectBuilderException {
        String projectPath = this.getProjectPath(line);
        if (projectPath == null) {
            return null;
        }
        return this.getProject(projectPath, this.getProjectPassword(line));
    }

    protected String getProjectPassword(CommandLine line) {
        String projectPassword = null;
        if (line.hasOption("w")) {
            projectPassword = line.getOptionValue("w");
        }
        return projectPassword;
    }

    protected String getProjectPath(CommandLine line) {
        String projectPath = null;
        if (line.hasOption("p")) {
            projectPath = line.getOptionValue("p");
        } else if (line.getArgs().length == 1) {
            projectPath = line.getArgs()[0];
        }
        return projectPath;
    }

    protected IProject getProject(String filePath, String password) throws ProjectBuilderException {
        if (filePath == null) {
            return null;
        }
        return this.projectBuilder.buildProject(new File(filePath), password);
    }
}

