/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.build.parser;

import com.microfocus.sv.svconfigurator.build.parser.AbstractProjectElementParser;
import com.microfocus.sv.svconfigurator.core.IProjectElement;
import com.microfocus.sv.svconfigurator.core.IProjectElementDataSource;
import com.microfocus.sv.svconfigurator.core.encryption.EncryptionMetadata;
import com.microfocus.sv.svconfigurator.core.impl.encryption.EncryptedNode;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXMLElementParser
extends AbstractProjectElementParser {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractXMLElementParser.class);
    public static String EncryptionMetadataElementName = "EncryptionMetadata";
    public static String EncryptedNodeElementName = "EncryptedNode";
    public static String EncryptionVersionAttributeName = "EncryptionVersion";
    public static String XPointerAttributeName = "xpointer";
    public static String TargetNameAttributeName = "targetName";
    static QName EncryptionMetadataElementQName = QName.valueOf(EncryptionMetadataElementName);

    protected EncryptionMetadata readEncryptionMetadata(XMLEventReader reader) throws XMLStreamException, SVCParseException {
        XMLEvent xmlEvent = null;
        while (reader.hasNext() && (xmlEvent == null || !xmlEvent.isStartElement())) {
            xmlEvent = reader.nextEvent();
        }
        if (xmlEvent == null || !xmlEvent.isStartElement()) {
            return null;
        }
        StartElement xmlStartElement = xmlEvent.asStartElement();
        QName encryptedDataStartElementName = xmlStartElement.getName();
        if (encryptedDataStartElementName == null || !EncryptionMetadataElementName.equals(encryptedDataStartElementName.getLocalPart())) {
            return null;
        }
        String encryptionVersion = "";
        Attribute attr = xmlStartElement.getAttributeByName(new QName(null, EncryptionVersionAttributeName));
        if (attr != null) {
            encryptionVersion = attr.getValue();
        }
        ArrayList<EncryptedNode> retVal = new ArrayList<EncryptedNode>();
        while (reader.hasNext() && !this.isEndElement(xmlEvent, EncryptionMetadataElementQName)) {
            QName qName;
            xmlEvent = reader.nextEvent();
            if (!xmlEvent.isStartElement() || (qName = (xmlStartElement = xmlEvent.asStartElement()).getName()) == null || !EncryptedNodeElementName.equals(qName.getLocalPart())) continue;
            String encryptedNodeXPath = AbstractXMLElementParser.getAttributeValue(xmlStartElement, XPointerAttributeName, false);
            String targetName = AbstractXMLElementParser.getAttributeValue(xmlStartElement, TargetNameAttributeName, false);
            if (encryptedNodeXPath == null || targetName == null) continue;
            retVal.add(new EncryptedNode(encryptedNodeXPath, targetName));
        }
        return new EncryptionMetadata(encryptionVersion, retVal);
    }

    private boolean isEndElement(XMLEvent xmlEvent, QName elementQName) {
        if (!xmlEvent.isEndElement()) {
            return false;
        }
        EndElement endElement = xmlEvent.asEndElement();
        return elementQName.equals(endElement.getName());
    }

    public static StartElement skipToElement(XMLEventReader reader, String element) throws SVCParseException, XMLStreamException {
        while (reader.hasNext()) {
            StartElement startEl;
            String localName;
            XMLEvent e = reader.nextEvent();
            if (!e.isStartElement() || !(localName = (startEl = e.asStartElement()).getName().getLocalPart()).equals(element)) continue;
            return startEl;
        }
        throw new SVCParseException("There was not found an element with name " + element);
    }

    public static String getAttributeValue(StartElement element, String attrName, boolean optional) throws SVCParseException {
        Attribute atr = element.getAttributeByName(QName.valueOf(attrName));
        if (atr == null) {
            if (optional) {
                LOG.debug("There is no attribute with name '" + attrName + "' in the element " + element.toString());
                return "";
            }
            throw new SVCParseException("There is no attribute with name '" + attrName + "' in the element " + element.toString());
        }
        return atr.getValue();
    }

    public abstract IProjectElement create(IProjectElementDataSource var1, XMLEventReader var2, String var3) throws SVCParseException, XMLStreamException;

    @Override
    public IProjectElement create(IProjectElementDataSource ds, String projectPassword) throws SVCParseException {
        InputStream is = null;
        try {
            is = ds.getData();
            XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
            xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
            xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            xmlInputFactory.setProperty("javax.xml.stream.isReplacingEntityReferences", false);
            XMLEventReader reader = xmlInputFactory.createXMLEventReader(is);
            IProjectElement iProjectElement = this.create(ds, reader, projectPassword);
            return iProjectElement;
        }
        catch (XMLStreamException ex) {
            throw new SVCParseException("Error during file parsing, did not you use stream from non verified file?", ex);
        }
        catch (IOException ex) {
            throw new SVCParseException("Zip Entry IO error.", ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
    }
}

