/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator.ant;

import com.microfocus.sv.svconfigurator.core.IProject;
import com.microfocus.sv.svconfigurator.core.impl.exception.CommunicatorException;
import com.microfocus.sv.svconfigurator.core.impl.jaxb.atom.ServiceListAtom;
import com.microfocus.sv.svconfigurator.core.impl.processor.Credentials;
import com.microfocus.sv.svconfigurator.processor.printer.IPrinter;
import com.microfocus.sv.svconfigurator.processor.printer.PrinterFactory;
import com.microfocus.sv.svconfigurator.serverclient.impl.CommandExecutor;
import com.microfocus.sv.svconfigurator.util.AntTaskUtil;
import com.microfocus.sv.svconfigurator.util.HttpUtils;
import com.microfocus.sv.svconfigurator.util.ProjectUtils;
import java.io.File;
import java.net.URL;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ListTask
extends Task {
    private File projectFile;
    private String username;
    private String password;
    private String url;
    private boolean trustEveryone = false;
    private String projectPassword;
    private String outputFormat = PrinterFactory.getDefaultFormat();

    public void execute() throws BuildException {
        this.validate();
        URL mgmtUri = AntTaskUtil.createUri(this.url, null);
        Credentials cred = ProjectUtils.createCredentials(this.username, this.password);
        try {
            CommandExecutor exec = new CommandExecutor(HttpUtils.createServerManagementEndpointClient(mgmtUri, this.trustEveryone, cred));
            IProject proj = this.projectFile != null ? AntTaskUtil.createProject(this.projectFile, this.projectPassword) : null;
            IPrinter printer = PrinterFactory.create(this.outputFormat);
            ServiceListAtom atom = exec.getServiceList(proj == null ? null : proj.getId());
            this.getProject().log(printer.createServiceListOutput(atom));
        }
        catch (CommunicatorException e) {
            throw new BuildException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void validate() throws BuildException {
        if (this.url == null) {
            throw new BuildException("Server management URL (url) have to be set.");
        }
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setTrustEveryone(boolean trustEveryone) {
        this.trustEveryone = trustEveryone;
    }

    public void setProjectPassword(String projectPassword) {
        this.projectPassword = projectPassword;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }
}

