/*
 * Decompiled with CFR 0.152.
 */
package com.microfocus.sv.svconfigurator;

import com.microfocus.sv.svconfigurator.LogConf;
import com.microfocus.sv.svconfigurator.cli.ICLICommandProcessor;
import com.microfocus.sv.svconfigurator.cli.ICLICommandProcessorFactory;
import com.microfocus.sv.svconfigurator.cli.impl.CLICommandRegistry;
import com.microfocus.sv.svconfigurator.cli.impl.factory.ChmodeCLICommandProcessorFactory;
import com.microfocus.sv.svconfigurator.cli.impl.factory.DeployCLICommandProcessorFactory;
import com.microfocus.sv.svconfigurator.cli.impl.factory.ExportCommandProcessorFactory;
import com.microfocus.sv.svconfigurator.cli.impl.factory.HotSwapCLICommandProcessorFactory;
import com.microfocus.sv.svconfigurator.cli.impl.factory.ListCLICommandProcessorFactory;
import com.microfocus.sv.svconfigurator.cli.impl.factory.ListProjectCLICommandProcessorFactory;
import com.microfocus.sv.svconfigurator.cli.impl.factory.SetLoggingCliCommandProcessorFactory;
import com.microfocus.sv.svconfigurator.cli.impl.factory.UndeployCLICommandProcessorFactory;
import com.microfocus.sv.svconfigurator.cli.impl.factory.UnlockCLICommandProcessorFactory;
import com.microfocus.sv.svconfigurator.cli.impl.factory.UpdateCommandProcessorFactory;
import com.microfocus.sv.svconfigurator.cli.impl.factory.ViewCLICommandProcessorFactory;
import com.microfocus.sv.svconfigurator.core.impl.exception.SVCParseException;
import com.microfocus.sv.svconfigurator.serverclient.impl.CommandExecutorFactory;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Main {
    private static final Logger LOG;

    public static void main(String[] args) throws Exception {
        LOG.debug("Initializing the SVConfigurator instance.");
        CommandExecutorFactory executorFactory = new CommandExecutorFactory();
        List<ICLICommandProcessorFactory> factories = Arrays.asList(new ChmodeCLICommandProcessorFactory(executorFactory), new DeployCLICommandProcessorFactory(executorFactory), new UndeployCLICommandProcessorFactory(executorFactory), new ListCLICommandProcessorFactory(executorFactory), new UnlockCLICommandProcessorFactory(executorFactory), new ViewCLICommandProcessorFactory(executorFactory), new HotSwapCLICommandProcessorFactory(executorFactory), new UpdateCommandProcessorFactory(executorFactory), new ExportCommandProcessorFactory(executorFactory), new ListProjectCLICommandProcessorFactory(), new SetLoggingCliCommandProcessorFactory(executorFactory));
        CLICommandRegistry registry = new CLICommandRegistry(factories);
        LOG.debug("Command Registry initialized.");
        try {
            if (args.length == 0) {
                throw new SVCParseException("You have to specify a command you want to execute.");
            }
            String command = args[0];
            String[] commandArgs = new String[args.length - 1];
            System.arraycopy(args, 1, commandArgs, 0, args.length - 1);
            ICLICommandProcessor cliProc = registry.lookupCommandProcessor(command);
            int res = cliProc.process(commandArgs);
            System.exit(res);
        }
        catch (SVCParseException e) {
            LOG.error(e.getLocalizedMessage());
            LOG.info(registry.getCLICommandHelp());
            System.exit(1000);
        }
    }

    static {
        LogConf.configure();
        LOG = LoggerFactory.getLogger(Main.class);
    }
}

