/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.utils;

import com.hp.octane.integrations.dto.entities.Entity;
import com.hp.octane.integrations.services.entities.EntitiesService;
import com.hp.octane.integrations.services.entities.QueryHelper;
import com.hp.octane.integrations.utils.SdkStringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class MbtDiscoveryResultHelper {
    private static boolean unitToRunnerRelationDefined(EntitiesService entitiesService, Long workspaceId) {
        String condition1 = QueryHelper.condition("entity_name", "model_item");
        String condition2 = QueryHelper.condition("name", "test_runner");
        List<Entity> entities = entitiesService.getEntities(workspaceId, "metadata/fields", Arrays.asList(condition1, condition2), Collections.emptyList());
        return !entities.isEmpty();
    }

    public static boolean newRunnerEnabled(EntitiesService entitiesService, Long workspaceId, String runnerId) {
        if (SdkStringUtils.isNotEmpty(runnerId) && MbtDiscoveryResultHelper.unitToRunnerRelationDefined(entitiesService, workspaceId)) {
            return MbtDiscoveryResultHelper.getRunnerDedicatedFolder(entitiesService, workspaceId, runnerId) != null;
        }
        return false;
    }

    public static Entity getRunnerDedicatedFolder(EntitiesService entitiesService, long workspaceId, String runnerId) {
        String condition1 = QueryHelper.conditionRef("test_runner", Long.parseLong(runnerId));
        String condition2 = QueryHelper.condition("subtype", "model_folder");
        List<Entity> entities = entitiesService.getEntities(workspaceId, "model_items", Arrays.asList(condition1, condition2), Collections.emptyList());
        return entities.stream().findFirst().orElse(null);
    }
}

