/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.uft.items;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.hp.octane.integrations.dto.executor.impl.TestingToolType;
import com.hp.octane.integrations.uft.items.AutomatedTest;
import com.hp.octane.integrations.uft.items.OctaneStatus;
import com.hp.octane.integrations.uft.items.ScmResourceFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.Charsets;

public class UftTestDiscoveryResult
implements Serializable {
    private List<AutomatedTest> tests = new ArrayList<AutomatedTest>();
    private List<ScmResourceFile> scmResourceFiles = new ArrayList<ScmResourceFile>();
    private Map<String, List<String>> combineDataTableHashCodeToTestPathListMap = new HashMap<String, List<String>>();
    private List<String> deletedFolders = new ArrayList<String>();
    private String scmRepositoryId;
    private String testRunnerId;
    private String workspaceId;
    private String configurationId;
    private TestingToolType testingToolType;
    private boolean fullScan;
    private boolean hasQuotedPaths;

    @JsonIgnore
    private List<AutomatedTest> getTestByOctaneStatus(OctaneStatus status) {
        return this.tests.stream().filter(automatedTest -> automatedTest.getOctaneStatus().equals((Object)status)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    @JsonIgnore
    private List<ScmResourceFile> getResourceFilesByOctaneStatus(OctaneStatus status) {
        return this.scmResourceFiles.stream().filter(scmResourceFile -> scmResourceFile.getOctaneStatus().equals((Object)status)).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    @JsonIgnore
    public List<AutomatedTest> getNewTests() {
        return this.getTestByOctaneStatus(OctaneStatus.NEW);
    }

    @JsonIgnore
    public List<AutomatedTest> getDeletedTests() {
        return this.getTestByOctaneStatus(OctaneStatus.DELETED);
    }

    @JsonIgnore
    public List<AutomatedTest> getUpdatedTests() {
        return this.getTestByOctaneStatus(OctaneStatus.MODIFIED);
    }

    public String getScmRepositoryId() {
        return this.scmRepositoryId;
    }

    public void setScmRepositoryId(String scmRepositoryId) {
        this.scmRepositoryId = scmRepositoryId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public boolean isFullScan() {
        return this.fullScan;
    }

    public void setFullScan(boolean fullScan) {
        this.fullScan = fullScan;
    }

    @JsonIgnore
    public boolean hasChanges() {
        return !this.getAllScmResourceFiles().isEmpty() || !this.getAllTests().isEmpty() || !this.getDeletedFolders().isEmpty();
    }

    @JsonIgnore
    public List<ScmResourceFile> getNewScmResourceFiles() {
        return this.getResourceFilesByOctaneStatus(OctaneStatus.NEW);
    }

    @JsonIgnore
    public List<ScmResourceFile> getDeletedScmResourceFiles() {
        return this.getResourceFilesByOctaneStatus(OctaneStatus.DELETED);
    }

    @JsonIgnore
    public List<ScmResourceFile> getUpdatedScmResourceFiles() {
        return this.getResourceFilesByOctaneStatus(OctaneStatus.MODIFIED);
    }

    public boolean isHasQuotedPaths() {
        return this.hasQuotedPaths;
    }

    public void setHasQuotedPaths(boolean hasQuotedPaths) {
        this.hasQuotedPaths = hasQuotedPaths;
    }

    public List<String> getDeletedFolders() {
        return this.deletedFolders;
    }

    public void setDeletedFolders(List<String> deletedFolders) {
        this.deletedFolders = deletedFolders;
    }

    @JsonProperty(value="tests")
    public List<AutomatedTest> getAllTests() {
        return this.tests;
    }

    @JsonProperty(value="tests")
    public void setAllTests(List<AutomatedTest> tests) {
        this.tests = tests;
    }

    @JsonProperty(value="dataTables")
    public List<ScmResourceFile> getAllScmResourceFiles() {
        return this.scmResourceFiles;
    }

    @JsonProperty(value="dataTables")
    public void setAllScmResourceFiles(List<ScmResourceFile> scmResourceFiles) {
        this.scmResourceFiles = scmResourceFiles;
    }

    @JsonProperty(value="combineDataTableHashCodeToTestPathListMap")
    public Map<String, List<String>> getCombineDataTableHashCodeToTestPathListMap() {
        return this.combineDataTableHashCodeToTestPathListMap;
    }

    @JsonProperty(value="combineDataTableHashCodeToTestPathListMap")
    public void setCombineDataTableHashCodeToTestPathListMap(Map<String, List<String>> combineDataTableHashCodeToTestPathListMap) {
        this.combineDataTableHashCodeToTestPathListMap = combineDataTableHashCodeToTestPathListMap;
    }

    public void writeToFile(File fileToWriteTo) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        ObjectWriter writer = mapper.writer((PrettyPrinter)new DefaultPrettyPrinter());
        writer.writeValue(fileToWriteTo, (Object)this);
    }

    public static UftTestDiscoveryResult readFromFile(File file) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8);
        ObjectMapper mapper = new ObjectMapper();
        UftTestDiscoveryResult result = (UftTestDiscoveryResult)mapper.readValue((Reader)reader, UftTestDiscoveryResult.class);
        return result;
    }

    public void sortItems() {
        UftTestDiscoveryResult.sortTests(this.tests);
        UftTestDiscoveryResult.sortDataTables(this.scmResourceFiles);
    }

    private static void sortTests(List<AutomatedTest> newTests) {
        Collections.sort(newTests, new Comparator<AutomatedTest>(){

            @Override
            public int compare(AutomatedTest o1, AutomatedTest o2) {
                int comparePackage = o1.getPackage().compareTo(o2.getPackage());
                if (comparePackage == 0) {
                    return o1.getName().compareTo(o2.getName());
                }
                return comparePackage;
            }
        });
    }

    private static void sortDataTables(List<ScmResourceFile> dataTables) {
        Collections.sort(dataTables, new Comparator<ScmResourceFile>(){

            @Override
            public int compare(ScmResourceFile o1, ScmResourceFile o2) {
                return o1.getRelativePath().compareTo(o2.getRelativePath());
            }
        });
    }

    public String getTestRunnerId() {
        return this.testRunnerId;
    }

    public void setTestRunnerId(String testRunnerId) {
        this.testRunnerId = testRunnerId;
    }

    public String getConfigurationId() {
        return this.configurationId;
    }

    public void setConfigurationId(String configurationId) {
        this.configurationId = configurationId;
    }

    public TestingToolType getTestingToolType() {
        return this.testingToolType;
    }

    public void setTestingToolType(TestingToolType testingToolType) {
        this.testingToolType = testingToolType;
    }
}

