/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.testresults;

import com.hp.octane.integrations.dto.DTOFactory;
import com.hp.octane.integrations.dto.tests.TestRunResult;
import com.hp.octane.integrations.testresults.GherkinXmlWritableTestResult;
import com.hp.octane.integrations.testresults.XmlWritableTestResult;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.poi.util.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GherkinUtils {
    public static void aggregateGherkinFilesToMqmResultFile(Collection<File> gherkinFiles, File mqmFile, String jobId, String buildId, DTOFactory optionalDtoFactory) throws Exception {
        List<XmlWritableTestResult> result = GherkinUtils.parseFiles(gherkinFiles);
        GherkinUtils.writeXmlFile(mqmFile, jobId, buildId, result, optionalDtoFactory);
    }

    public static List<XmlWritableTestResult> parseFiles(Collection<File> gherkinFiles) throws ParserConfigurationException, SAXException, IOException {
        ArrayList<XmlWritableTestResult> result = new ArrayList<XmlWritableTestResult>();
        for (File file : gherkinFiles) {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(file);
            doc.getDocumentElement().normalize();
            GherkinUtils.validateXMLVersion(doc);
            NodeList featureNodes = doc.getElementsByTagName("feature");
            for (int f = 0; f < featureNodes.getLength(); ++f) {
                Element featureElement = (Element)featureNodes.item(f);
                FeatureInfo featureInfo = new FeatureInfo(featureElement);
                result.add(new GherkinXmlWritableTestResult(featureInfo.getName(), featureElement, featureInfo.getDuration(), featureInfo.getStatus()));
            }
        }
        return result;
    }

    public static List<File> findGherkinFilesByTemplateWithCounter(String folder, String fileTemplate, int counterStart) {
        File file;
        ArrayList<File> result = new ArrayList<File>();
        int i = counterStart;
        while ((file = new File(folder, String.format(fileTemplate, i++))).exists()) {
            result.add(file);
        }
        return result;
    }

    private static void validateXMLVersion(Document doc) {
        String XML_VERSION = "1";
        NodeList featuresNodes = doc.getElementsByTagName("features");
        if (featuresNodes.getLength() > 0) {
            String versionAttr = ((Element)featuresNodes.item(0)).getAttribute("version");
            if (versionAttr == null || versionAttr.isEmpty() || versionAttr.compareTo(XML_VERSION) != 0) {
                throw new IllegalArgumentException("\n********************************************************\nIncompatible xml version received from the Octane formatter.\nexpected version = " + XML_VERSION + " actual version = " + versionAttr + ".\nYou may need to update the octane formatter version to the correct version in order to work with this plugin\n********************************************************");
            }
        } else {
            throw new IllegalArgumentException("The file does not contain Octane Gherkin results. Configuration error?");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeXmlFile(File mqmFile, String planName, String buildNumber, List<XmlWritableTestResult> gherkinXmlWritableTestResults, DTOFactory dtoFactory) throws IOException, XMLStreamException {
        FileOutputStream outputStream = new FileOutputStream(mqmFile);
        try {
            if (dtoFactory == null) {
                dtoFactory = DTOFactory.getInstance();
            }
            XMLStreamWriter writer = dtoFactory.getXMLMapper().getFactory().getXMLOutputFactory().createXMLStreamWriter(outputStream, "UTF-8");
            if (!gherkinXmlWritableTestResults.isEmpty()) {
                writer.writeStartDocument("UTF-8", "1.0");
                writer.writeStartElement("test_result");
                writer.writeStartElement("build");
                writer.writeAttribute("server_id", "to-be-filled-in-SDK");
                writer.writeAttribute("job_id", planName);
                writer.writeAttribute("build_id", buildNumber);
                writer.writeEndElement();
                writer.writeStartElement("test_runs");
                for (XmlWritableTestResult g : gherkinXmlWritableTestResults) {
                    g.writeXmlElement(writer);
                }
                writer.writeEndElement();
                writer.writeEndElement();
                writer.writeEndDocument();
            }
            writer.flush();
            writer.close();
        }
        finally {
            IOUtils.closeQuietly((Closeable)outputStream);
        }
    }

    private static class FeatureInfo {
        private String name;
        private List<String> scenarioNames = new ArrayList<String>();
        private TestRunResult status = TestRunResult.SKIPPED;
        private boolean statusDetermined = false;
        private long duration = 0L;

        public FeatureInfo(Element featureElement) {
            this.name = featureElement.getAttribute("name");
            NodeList backgroundNodes = featureElement.getElementsByTagName("background");
            Element backgroundElement = backgroundNodes.getLength() > 0 ? (Element)backgroundNodes.item(0) : null;
            NodeList backgroundSteps = backgroundElement != null ? backgroundElement.getElementsByTagName("step") : null;
            NodeList scenarioNodes = featureElement.getElementsByTagName("scenario");
            for (int s = 0; s < scenarioNodes.getLength(); ++s) {
                Element scenarioElement = (Element)scenarioNodes.item(s);
                ScenarioInfo scenarioInfo = new ScenarioInfo(scenarioElement, backgroundSteps);
                String scenarioName = scenarioInfo.getName();
                this.scenarioNames.add(scenarioName);
                this.duration += scenarioInfo.getDuration();
                if (!this.statusDetermined && TestRunResult.PASSED.equals((Object)scenarioInfo.getStatus()) && !this.status.equals((Object)TestRunResult.PASSED)) {
                    this.status = TestRunResult.PASSED;
                    continue;
                }
                if (this.statusDetermined || !TestRunResult.FAILED.equals((Object)scenarioInfo.getStatus())) continue;
                this.status = TestRunResult.FAILED;
                this.statusDetermined = true;
            }
            this.statusDetermined = true;
        }

        public String getName() {
            return this.name;
        }

        public TestRunResult getStatus() {
            return this.status;
        }

        public long getDuration() {
            return this.duration;
        }

        private static class ScenarioInfo {
            private List<String> stepNames = new ArrayList<String>();
            private long duration = 0L;
            private TestRunResult status = TestRunResult.PASSED;
            private boolean statusDetermined = false;
            private String name;

            public ScenarioInfo(Element scenarioElement, NodeList backgroundSteps) {
                this.name = this.getScenarioName(scenarioElement);
                List<Element> stepElements = this.getStepElements(backgroundSteps, scenarioElement);
                for (Element stepElement : stepElements) {
                    this.addStep(stepElement);
                }
                scenarioElement.setAttribute("status", this.status.value());
                this.stepNames.add(this.name);
                this.stepNames.add("Scenario: " + this.name);
            }

            public long getDuration() {
                return this.duration;
            }

            public TestRunResult getStatus() {
                return this.status;
            }

            public String getName() {
                return this.name;
            }

            private void addStep(Element stepElement) {
                String stepName = stepElement.getAttribute("name");
                this.stepNames.add(stepName);
                String durationStr = stepElement.getAttribute("duration");
                long stepDuration = durationStr != "" ? Long.parseLong(durationStr) : 0L;
                this.duration += stepDuration;
                String stepStatus = stepElement.getAttribute("status");
                if (!this.statusDetermined && ("pending".equals(stepStatus) || "skipped".equals(stepStatus))) {
                    this.status = TestRunResult.SKIPPED;
                    this.statusDetermined = true;
                } else if (!this.statusDetermined && "failed".equals(stepStatus)) {
                    this.status = TestRunResult.FAILED;
                    this.statusDetermined = true;
                }
            }

            private List<Element> getStepElements(NodeList backgroundSteps, Element scenarioElement) {
                ArrayList<Element> stepElements = new ArrayList<Element>();
                if (backgroundSteps != null) {
                    for (int bs = 0; bs < backgroundSteps.getLength(); ++bs) {
                        Element stepElement = (Element)backgroundSteps.item(bs);
                        stepElements.add(stepElement);
                    }
                }
                NodeList stepNodes = scenarioElement.getElementsByTagName("step");
                for (int sn = 0; sn < stepNodes.getLength(); ++sn) {
                    Element stepElement = (Element)stepNodes.item(sn);
                    stepElements.add(stepElement);
                }
                return stepElements;
            }

            private String getScenarioName(Element scenarioElement) {
                Integer outlineIndex;
                String outlineIndexStr;
                String scenarioName = scenarioElement.getAttribute("name");
                if (scenarioElement.hasAttribute("outlineIndex") && (outlineIndexStr = scenarioElement.getAttribute("outlineIndex")) != null && !outlineIndexStr.isEmpty() && (outlineIndex = Integer.valueOf(scenarioElement.getAttribute("outlineIndex"))) > 1) {
                    String delimiter = " ";
                    if (!scenarioName.contains(" ")) {
                        delimiter = "_";
                    }
                    scenarioName = scenarioName + delimiter + scenarioElement.getAttribute("outlineIndex");
                }
                return scenarioName;
            }
        }
    }
}

