/*
 * Decompiled with CFR 0.152.
 */
package com.hp.octane.integrations.services.vulnerabilities.ssc;

import com.hp.octane.integrations.dto.securityscans.SSCProjectConfiguration;
import com.hp.octane.integrations.exceptions.PermanentException;
import com.hp.octane.integrations.services.rest.SSCRestClient;
import com.hp.octane.integrations.services.vulnerabilities.DateUtils;
import com.hp.octane.integrations.services.vulnerabilities.VulnerabilitiesQueueItem;
import com.hp.octane.integrations.services.vulnerabilities.ssc.SSCProjectConnector;
import com.hp.octane.integrations.services.vulnerabilities.ssc.dto.Artifacts;
import com.hp.octane.integrations.services.vulnerabilities.ssc.dto.IssueDetails;
import com.hp.octane.integrations.services.vulnerabilities.ssc.dto.Issues;
import com.hp.octane.integrations.services.vulnerabilities.ssc.dto.ProjectVersions;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SSCHandler {
    private static final Logger logger = LogManager.getLogger(SSCHandler.class);
    private SSCProjectConnector sscProjectConnector;
    private ProjectVersions.ProjectVersion projectVersion;
    private long runStartTime;
    public static final String SCAN_RESULT_FILE = "securityScan.json";
    public static final String ARTIFACT_STATUS_COMPLETE = "PROCESS_COMPLETE";
    public static final String ARTIFACT_ERROR_PROCESSING = "ERROR_PROCESSING";

    public boolean isScanProcessFinished() {
        logger.debug("enter isScanProcessFinished");
        Artifacts artifacts = this.sscProjectConnector.getArtifactsOfProjectVersion(this.projectVersion.id, 10);
        logger.debug("artifacts: " + artifacts.toString());
        Artifacts.Artifact closestArtifact = this.getClosestArtifact(artifacts);
        if (closestArtifact == null) {
            logger.debug("Cannot find artifact of the run");
            return false;
        }
        if (closestArtifact.status.equals(ARTIFACT_STATUS_COMPLETE)) {
            logger.debug("artifact of the run is in completed");
            return true;
        }
        if (closestArtifact.status.equals(ARTIFACT_ERROR_PROCESSING)) {
            throw new PermanentException("artifact of the run faced error, polling should stop");
        }
        logger.debug("artifact of the run is not complete, polling should continue");
        return false;
    }

    private Artifacts.Artifact getClosestArtifact(Artifacts artifacts) {
        Artifacts.Artifact theCloset = null;
        if (artifacts == null) {
            logger.debug("getClosestArtifact artifacts is null");
            return null;
        }
        if (artifacts.getData() == null) {
            logger.debug("getClosestArtifact artifacts.getData() is null");
            return null;
        }
        Date startRunDate = new Date(this.runStartTime);
        Calendar cal = Calendar.getInstance();
        cal.setTime(startRunDate);
        cal.set(13, 0);
        cal.add(12, -1);
        startRunDate = cal.getTime();
        logger.debug("startRunDate:  " + startRunDate.toString());
        for (Artifacts.Artifact artifact : artifacts.getData()) {
            Date uploadDate = DateUtils.getDateFromUTCString(artifact.uploadDate, "yyyy-MM-dd'T'HH:mm:ss");
            if (uploadDate == null) {
                logger.debug(" uploadDate is null");
            } else {
                logger.debug(" uploadDate: " + uploadDate.toString());
            }
            if (uploadDate == null || !uploadDate.after(startRunDate)) continue;
            theCloset = artifact;
        }
        return theCloset;
    }

    public SSCHandler() {
    }

    public SSCHandler(VulnerabilitiesQueueItem vulnerabilitiesQueueItem, SSCProjectConfiguration sscProjectConfiguration, SSCRestClient sscRestClient) {
        if (vulnerabilitiesQueueItem == null) {
            throw new IllegalArgumentException("vulnerabilities QueueItem MUST NOT be null");
        }
        if (sscProjectConfiguration == null) {
            throw new IllegalArgumentException("SSC project configuration MUST NOT be null");
        }
        if (sscRestClient == null) {
            throw new IllegalArgumentException("sscClient MUST NOT be null");
        }
        logger.debug("real initializing code");
        this.runStartTime = vulnerabilitiesQueueItem.getStartTime();
        if (!sscProjectConfiguration.isValid()) {
            throw new PermanentException("SSC configuration invalid, will not continue connecting to the server");
        }
        this.sscProjectConnector = new SSCProjectConnector(sscProjectConfiguration, sscRestClient);
        this.projectVersion = this.sscProjectConnector.getProjectVersion();
        logger.debug("Project version Id:" + this.projectVersion.id);
    }

    public Optional<Issues> getIssuesIfScanCompleted() {
        if (!this.isScanProcessFinished()) {
            logger.debug("getIssuesIfScanCompleted - isScanProcessFinished = false ");
            return Optional.empty();
        }
        Issues issues = this.sscProjectConnector.readIssues(this.projectVersion.id);
        logger.debug("issues.count: " + String.valueOf(issues.getCount()));
        return Optional.of(issues);
    }

    public Map<Integer, IssueDetails> getIssuesExtendedData(List<Issues.Issue> issues) {
        HashMap<Integer, IssueDetails> idToDetails = new HashMap<Integer, IssueDetails>();
        try {
            for (Issues.Issue issue : issues) {
                IssueDetails issueDetails = this.sscProjectConnector.getIssueDetails(issue.id);
                idToDetails.put(issue.id, issueDetails);
            }
        }
        catch (Exception e) {
            logger.error("failed to add extended data for issues", (Throwable)e);
        }
        return idToDetails;
    }
}

